/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ole;

import java.io.IOException;
import org.openantivirus.ole.OLEPage;

public class OLEFileInformationBlock
extends OLEPage {
    public static final byte[] MAGIC = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private int rootChainStart;
    private int numBigBlocks;
    private int smallBlockStart;

    public OLEFileInformationBlock(byte[] byArray) throws IOException {
        super(byArray);
        int n = 0;
        while (n < MAGIC.length) {
            if (byArray[n] != MAGIC[n]) {
                throw new IOException("Not an OLE file");
            }
            ++n;
        }
        this.numBigBlocks = this.getInt(44);
        this.rootChainStart = this.getInt(48);
        this.smallBlockStart = this.getInt(60);
    }

    public int getRootChainStart() {
        return this.rootChainStart;
    }

    public int getNumBigBlocks() {
        return this.numBigBlocks;
    }

    public int getSmallBlockStart() {
        return this.smallBlockStart;
    }

    public int getBigBlockPageIndex(int n) {
        return this.getInt(76 + n * 4);
    }
}

