/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ole;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;
import org.openantivirus.ole.OLEDirectory;
import org.openantivirus.ole.OLEFileInformationBlock;
import org.openantivirus.ole.OLEPage;
import org.openantivirus.ole.OLEPageList;
import org.openantivirus.ole.OLEPageMap;

public class OLEFile {
    private File file;
    private long maxPage;
    private OLEFileInformationBlock oleFIB;
    private RandomAccessFile raf;
    private OLEPageMap oleBBPM = new OLEPageMap();
    private OLEPageMap oleDPM = new OLEPageMap();
    private OLEDirectory oleDir = new OLEDirectory();

    public OLEFile(File file) throws IOException {
        this.file = file;
        this.maxPage = file.length() / 512L - 2L;
        this.raf = new RandomAccessFile(file, "r");
        this.oleFIB = new OLEFileInformationBlock(this.getPage(-1));
        int n = 0;
        while (n < this.oleFIB.getNumBigBlocks()) {
            this.oleBBPM.addBlockPage(this.getOLEPage(this.oleFIB.getBigBlockPageIndex(n)));
            ++n;
        }
        OLEPageList oLEPageList = this.oleBBPM.getPageList(this.oleFIB.getRootChainStart());
        Iterator iterator = oLEPageList.iterator();
        while (iterator.hasNext()) {
            this.oleDir.addDirectoryPage(this.getOLEPage((Integer)iterator.next()));
        }
        oLEPageList = this.oleBBPM.getPageList(this.oleFIB.getSmallBlockStart());
        Iterator iterator2 = oLEPageList.iterator();
        while (iterator2.hasNext()) {
            this.oleDPM.addBlockPage(this.getOLEPage((Integer)iterator2.next()));
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public OLEFileInformationBlock getFileInformationBlock() throws IOException {
        return this.oleFIB;
    }

    public byte[] getPage(int n) throws IOException {
        byte[] byArray = new byte[512];
        this.raf.seek(512 * (n + 1));
        this.raf.readFully(byArray);
        return byArray;
    }

    public OLEPage getOLEPage(int n) throws IOException {
        return new OLEPage(this.getPage(n));
    }

    public OLEPageMap getBigBlockPageMap() {
        return this.oleBBPM;
    }

    public OLEDirectory getDirectory() {
        return this.oleDir;
    }

    public OLEPageMap getSmallBlockPageMap() {
        return this.oleDPM;
    }

    public List getDirectoryEntryList() {
        return this.oleDir.getDirectoryEntryList();
    }
}

