/*
 * $Id: ScannerOutputPanel.java,v 1.3 2002/04/10 16:29:28 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * ScannerOutputPanel
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.3 $
 */
public class ScannerOutputPanel extends JPanel {
    public static final String VERSION =
        "$Id: ScannerOutputPanel.java,v 1.3 2002/04/10 16:29:28 kurti Exp $";
    
    private final DefaultTableModel outputModel = new DefaultTableModel(
            new String[] {
                L10N.getString("Filename"), L10N.getString("Path"),
                L10N.getString("Infected_by")
            }, 0);
    
    private final JTable outputTable = new JTable(outputModel);
    
    public ScannerOutputPanel() {
        super(new BorderLayout());
        final JScrollPane jsp = new JScrollPane(outputTable);
        add(jsp, BorderLayout.CENTER);
        outputTable.setShowGrid(false);
    }
    
    public void addFoundVirus(File file, String virusname) {
        outputModel.addRow(new String[] {file.getName(), file.getParent(),
                                         virusname});
    }
    
    public void clearList() {
        outputModel.setRowCount(0);
    }
}
