/*
 * $Id: TrieScanner.java,v 1.1 2001/12/12 23:59:38 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.util.Iterator;

/**
 * TrieScanner
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 *
 */
public class TrieScanner implements StreamScanner {
    public static final String VERSION =
        "$Id: TrieScanner.java,v 1.1 2001/12/12 23:59:38 kurti Exp $";
    
    private Node nRoot, nCurrent;
    
    public TrieScanner(Trie trie) {
        nRoot  = trie.getRootNode();
        reset();
    }
    
    /**
     * scans the next block of the stream for virii; blocks are expected to
     * appear in the correct order
     */
    public void update(byte[] ab, int iOffset, int iLength,
                       int iPrefix, int iPostfix) throws VirusFoundException {
        for (int i = iOffset; i < iOffset + iLength; i++) {
            nCurrent = nCurrent.getTrans(ab[ i ] & 0xff);
            if (nCurrent.isLastNode()) {
                int iPosition = i - Trie.MINIMUM_LENGTH + 1;
                PositionFoundEvent pfe = new PositionFoundEvent(ab, iPosition,
                        Trie.MINIMUM_LENGTH, iPosition - iOffset + iPrefix,
                        iOffset + iLength - iPosition + iPostfix
                            - Trie.MINIMUM_LENGTH);
                
                Iterator it = nCurrent.getStringSearchListener().iterator();
                while (it.hasNext()) {
                    PositionFoundListener pfl =
                        (PositionFoundListener) it.next();
                    pfl.positionFound(pfe);
                }
            }
        }
    }
    
    /** resets the internal state of the scanner; usually at end of file  */
    public void reset() {
        nCurrent = nRoot;
    }
}
