/*
 * $Id: StringFinder.java,v 1.1 2001/12/12 23:59:38 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

/**
 * StringFinder
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class StringFinder {
    public static final String VERSION =
        "$Id: StringFinder.java,v 1.1 2001/12/12 23:59:38 kurti Exp $";
    
    private Trie trie;
    
    public StringFinder(Trie trie) {
        this.trie = trie;
    }
    
    public void addString(String sPattern, PositionFoundListener pfl) {
        trie.addString(sPattern, new PartialStringFoundListener(sPattern, pfl));
    }
    
    private class PartialStringFoundListener implements PositionFoundListener {
        private byte[ ]               abPattern;
        private PositionFoundListener pfl;
        
        public PartialStringFoundListener(String sPattern,
                                          PositionFoundListener pfl) {
             abPattern = sPattern.getBytes();
             this.pfl  = pfl;
        }
        
        public void positionFound(PositionFoundEvent pfe)
                throws VirusFoundException {
            byte[] abBuffer    = pfe.getBuffer();
            int    iBufferPos  = pfe.getOffset()
                                 + pfe.getLength();
            int    iPostfixEnd = pfe.getOffset() + pfe.getLength()
                                 + pfe.getPostfixLength();
            
            for (int i = pfe.getLength();
                 i < abPattern.length;
                 i++) {
                iBufferPos %= abBuffer.length;
                if (iBufferPos == iPostfixEnd) {
                    return;
                }
                
                if (abPattern[i] != abBuffer[iBufferPos]) {
                    return;
                }
                iBufferPos++;
            }
            pfl.positionFound(pfe);
        }
    }
}
