package org.openantivirus.scanner;

/**
 * Contains all information for the scanner itself, e.g. Trie. It is used as
 * a container, so that the API does not need to be changed if additional
 * parameters are needed.
 *
 * Pattern-Roles: Container
 * @author  Kurt Huwig
 * @version $Id: ScannerConfiguration.java,v 1.1 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class ScannerConfiguration {
    public static final String VERSION =
        "$Id: ScannerConfiguration.java,v 1.1 2002/04/10 16:29:27 kurti Exp $";
    
    private final Trie trie = new Trie();
    
    public Trie getTrie() {
        return trie;
    }
}
