/*
 * $Id: ScanTargetList.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.util.*;

/**
 * ScanTargetList
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ScanTargetList extends javax.swing.AbstractListModel  {
    public static final String VERSION =
        "$Id: ScanTargetList.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    private final List targetList = new ArrayList();
    
    public void addScanTarget(ScanTarget target) {
        final int insertIndex = targetList.size();
        
        targetList.add(target);
        fireIntervalAdded(this, insertIndex, insertIndex + 1);
    }
    
    public void removeScanTarget(int removeIndex) {
        targetList.remove(removeIndex);
        fireIntervalRemoved(this, removeIndex, removeIndex);
    }
    
    public void removeScanTarget(ScanTarget scanTarget) {
        removeScanTarget(targetList.indexOf(scanTarget));
    }
    
    public int getSize() {
        return targetList.size();
    }
    
    public Object getElementAt(int index) {
        return index >= 0 ? targetList.get(index) : null;
    }
}
