/*
 * $Id: ExplorerPanel.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import javax.swing.*;
import javax.swing.table.*;
import java.io.*;
import java.beans.*;
import java.awt.*;
import javax.swing.event.*;

/**
 * ExplorerPanel
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ExplorerPanel extends JPanel {
    public static final String VERSION =
        "$Id: ExplorerPanel.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    /** Table for the scantargets */
    private final JTable jtFiles = new JTable();
    
    /** Column names of the scantargets */
    private static final String[] COLUMN_NAMES = {
        "Target_name", "Subfolders"
    };
    
    /** Actions */
    private final AddTargetAction addTargetAction = new AddTargetAction();
    private final RemoveTargetAction removeTargetAction =
            new RemoveTargetAction();
    
    /** Listener */
    private final ListSelectionListener scanTargetListListener =
            new ListSelectionListener() {
        public void valueChanged(ListSelectionEvent lse) {
            removeTargetAction.setScanTarget((ScanTarget) scanTargetList
                    .getElementAt(jtFiles.getSelectedRow()));
        }
    };
    
    /** Holds value of property scanTargetList. */
    private ScanTargetList scanTargetList;
    
    public ExplorerPanel() {
        super(new BorderLayout());
        
        createTargetTable();
        createActionPanel();
        registerListener();
    }
    
    /** creates the table for the scantargets */
    protected void createTargetTable() {
        jtFiles.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        add(new JScrollPane(jtFiles), BorderLayout.CENTER);
    }
    
    /** creates the panel with the actions */
    protected void createActionPanel() {
        final JPanel jp = new JPanel();
        
        JButton jb = new JButton(addTargetAction);
        jb.setMnemonic(L10N.getMnemonic("Add"));
        jp.add(jb);
        
        jb = new JButton(removeTargetAction);
        jb.setMnemonic(L10N.getMnemonic("Remove"));
        jp.add(jb);
        add(jp, BorderLayout.SOUTH);
    }

    /** registers the local listeners */
    protected void registerListener() {
        jtFiles.getSelectionModel().addListSelectionListener(
                scanTargetListListener);
    }
    
    /** Setter for property scanTargetList.
     * @param scanTargetList New value of property scanTargetList.
     */
    public void setScanTargetList(ScanTargetList newScanTargetList) {
        scanTargetList = newScanTargetList;
        
        final AbstractTableModel model = new AbstractTableModel() {
            public int getRowCount() {
                return scanTargetList.getSize();
            }
            
            public int getColumnCount() {
                return COLUMN_NAMES.length;
            }
            
            public String getColumnName(int column) {
                return L10N.getString(COLUMN_NAMES[column]);
            }
            
            public Object getValueAt(int row, int column) {
                final ScanTarget st = (ScanTarget) scanTargetList.getElementAt(
                        row);
                switch (column) {
                case 0:
                    return st.getPath();
                case 1:
                    return st.getSubfolders() ? L10N.getString("Yes")
                                              : L10N.getString("No");
                }
                return null;
            }
            
        };
        
        scanTargetList.addListDataListener(new ListDataListener() {
            public void intervalAdded(ListDataEvent lde) {
                model.fireTableRowsInserted(lde.getIndex0(), lde.getIndex1());
            }
            
            public void intervalRemoved(ListDataEvent lde) {
                jtFiles.getSelectionModel().setSelectionInterval(-1, -1);
                model.fireTableRowsDeleted(lde.getIndex0(), lde.getIndex1());
            }
            
            public void contentsChanged(ListDataEvent lde) {
                model.fireTableRowsUpdated(lde.getIndex0(), lde.getIndex1());
            }
        });
        jtFiles.setModel(model);
        
        final TableColumnModel tcm = jtFiles.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(300);
        tcm.getColumn(1).setPreferredWidth(100);
        
        addTargetAction.setScanTargetList(scanTargetList);
        removeTargetAction.setScanTargetList(scanTargetList);
    }
}
