/*
 * $Id: PEHeader.java,v 1.1 2002/05/13 22:21:01 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.ucl;

/**
 * Header of a PE file
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class PEHeader extends CStructure {
    public static final String VERSION =
        "$Id: PEHeader.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";
    
    public static final int SIZE = 248;
    
    /** Offsets */
    private static final int
        OBJECTS      = 6,
        ENTRY        = 40,
        DDIRS_START  = 120,
        DDIRS_LENGTH = 8,
        DDIRS_VADDR  = 0,
        DDIRS_SIZE   = 4;
        
    
    public PEHeader(byte[] data) {
        super(data, SIZE);
    }
    
    public int getObjects() {
        return getLE16(OBJECTS);
    }
    
    public long getEntry() {
        return getLE32(ENTRY);
    }
    
    public long getDDirsSize(int index) {
        return getLE32(DDIRS_START + DDIRS_LENGTH * index + DDIRS_SIZE);
    }
}
