/*
 * $Id: ScanObject.java,v 1.1 2002/05/13 22:21:00 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.scanobject;

import java.io.*;

/**
 * Represents an object to be scanned for viruses
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public interface ScanObject {
    String VERSION =
        "$Id: ScanObject.java,v 1.1 2002/05/13 22:21:00 kurti Exp $";
    
    /** Maximum size of the start array */
    public static final int MAX_START_SIZE = 2048;
    
    /**
     * @return the first block of bytes from the object; should be at least 2kB
     */
    byte[] getStart() throws IOException;
    
    /** @return File for the object; the caller HAS TO close all streams to it */
    File getFile() throws IOException;
    
    /** called if the ScanObject is not needed any more */
    void dispose() throws IOException;
}
