/*
 * $Id: ExecutableFilterFactory.java,v 1.2 2002/05/14 21:33:31 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.filter;

import java.io.*;
import org.openantivirus.scanner.*;
import org.openantivirus.scanner.scanobject.*;
import org.openantivirus.ucl.*;

/**
 * ExecutableFilterFactory
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ExecutableFilterFactory implements FilterFactory {
    public static final String VERSION =
        "$Id: ExecutableFilterFactory.java,v 1.2 2002/05/14 21:33:31 kurti Exp $";
    
    private final ScannerConfiguration scannerConfiguration;
    
    public ExecutableFilterFactory(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
    }
    
    /**
     * @return Filter for the ScanObject or null if the factory does not know
     *         how to filter it
     */
    public Filter getFilterFor(ScanObject scanObject) throws IOException {
        final byte[] start = scanObject.getStart();
        
        // DOS EXE
        if (start[0] == 'M' && start[1] == 'Z') {
            final File file = scanObject.getFile();
            final RandomAccessFile raf = new RandomAccessFile(file, "r");
            final UPXDecompress upxDecompress =
                    new UPXDecompress(raf, file.length());
            
            boolean canUnpack;
            try {
                canUnpack = upxDecompress.canUnpack();
            } catch (Exception e) {
                // if anything goes wrong, we cannot unpack!
                e.printStackTrace();
                canUnpack = false;
            }
            if (canUnpack) {
                // UPXFilter closes the RandomAccessFile
                return new UPXFilter(raf, upxDecompress, scannerConfiguration);
            } else {
                raf.close();
            }
            
            return new TrieScanFilter(scannerConfiguration.getTrie());
        }
        
        return null;
    }    
    
}
