/*
 * $Id: DecompressFilterFactory.java,v 1.1 2002/05/13 22:21:00 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.filter;

import java.io.*;
import org.openantivirus.scanner.scanobject.*;

/**
 * A FilterFactory for decompressing Filter
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class DecompressFilterFactory implements FilterFactory {
    public static final String VERSION =
    "$Id: DecompressFilterFactory.java,v 1.1 2002/05/13 22:21:00 kurti Exp $";
    
    /** @return Filter for the ScanObject or null if the factory does not know
     *         how to filter it
     */
    public Filter getFilterFor(ScanObject scanObject) throws IOException {
        byte[] start = scanObject.getStart();
        
        // ZIP
        if (start[0] == 'P' && start[1] == 'K'
                && start[2] == 3 && start[3] == 4) {
            return ZipFilter.getInstance();
        }
        
        // Microsoft Cabinet
        if (start[0] == 'M' && start[1] == 'S' && start[2] == 'C'
                && start[3] == 'F'  && start[4] == 0x00 && start[5] == 0x00
                && start[6] == 0x00 && start[7] == 0x00) {
            System.err.println("Cannot scan Microsoft Cabinet files");
            return NullFilter.getInstance();
        }
        
        return null;
    }
    
}
