/*
 * $Id: VirusFoundException.java,v 1.3 2002/04/23 09:05:29 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001-02 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.io.*;

/**
 * VirusFoundException
 *
 * @author  Kurt Huwig
 * @version $Revision: 1.3 $
 */
public class VirusFoundException extends java.lang.Exception {
    public static final String VERSION =
        "$Id: VirusFoundException.java,v 1.3 2002/04/23 09:05:29 kurti Exp $";

    private final String sVirusName;
    private File file = null;
    
    /**
     * Constructs an <code>VirusFoundException</code>
     * @param sVirusName the name of the virus
     */
    public VirusFoundException(String sVirusName) {
        this.sVirusName = sVirusName;
    }
    
    /**
     * Sets the filename of the virus
     */
    public void setFile(File virusFile) {
        file = virusFile;
    }
    
    public String getVirusName() {
        return sVirusName;
    }
    
    public String getMessage() {
        String result = "FOUND: " + sVirusName;
        
        if (file != null) {
            result += " in " + file.getAbsolutePath();
        }
        
        return result;
    }

}
