/*
 * $Id: StringVirusFinder.java,v 1.6 2002/04/22 09:44:24 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.io.*;

/**
 * Detects virii by a simple string
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.6 $
 */
public class StringVirusFinder {
    public static final String VERSION =
        "$Id: StringVirusFinder.java,v 1.6 2002/04/22 09:44:24 kurti Exp $";
    
    public StringVirusFinder(Reader patternReader, StringFinder stringFinder)
                throws IOException {

        final BufferedReader br = new BufferedReader(patternReader);
            
        String sLine;
        while ((sLine = br.readLine()) != null) {
            int iPos = sLine.indexOf('=');
            if (iPos == -1) {
                System.err.println("Malformed pattern line: " + sLine);
                continue;
            }
            
            String sVirusName = sLine.substring(0, iPos);
            String sPattern   = sLine.substring(iPos + 1);
            
            try {
                stringFinder.addString(hexToString(sPattern),
                        new StringVirusFoundListener(sVirusName));
            } catch (Exception e) {
                System.err.println(sLine);
                e.printStackTrace();
            }
        }
        br.close();
    }
    
    protected byte[] hexToString(String hex) {
        if (hex.length() % 2 != 0) {
            System.err.println("Malformed hexstring: " + hex);
            return null;
        }
        
        final byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            result[i / 2] = (byte) Integer.parseInt(hex.substring(i, i + 2),
                                                    16);
        }
        
        return result;
    }
            

    
    private class StringVirusFoundListener implements PositionFoundListener {
        private String virusName, pattern;
        
        public StringVirusFoundListener(String virusName) {
            this.virusName = virusName;
        }
        
        public void positionFound(PositionFoundEvent sfe)
                throws VirusFoundException {
            throw new VirusFoundException(virusName);
        }
    }
}
