/*
 * $Id: ScannerListener.java,v 1.1 2002/02/24 16:15:10 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.util.*;

/**
 * Listener for events occuring during scanning
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public interface ScannerListener extends EventListener {
    String VERSION =
        "$Id: ScannerListener.java,v 1.1 2002/02/24 16:15:10 kurti Exp $";
    
    /** called when the scan is about to start */
    void startingScan();
    
    /**
     * called, when a Virus has been found
     * @throws VirusFoundException if the scanning should be stopped
     */
    void virusFound(VirusFoundException virusFoundException)
            throws VirusFoundException;
    
    /** called when the scan has finished */
    void finishedScan();
}
