/*
 * $Id: Scanner.java,v 1.2 2002/05/14 21:33:31 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.io.*;
import org.openantivirus.scanner.filter.*;
import org.openantivirus.scanner.scanobject.*;

/**
 * Scanner
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class Scanner {
    public static final String VERSION =
        "$Id: Scanner.java,v 1.2 2002/05/14 21:33:31 kurti Exp $";
    
    /** List of all known FilterFactories; tried from top to botton */
    private final FilterFactory[] filterFactories;
    
    private final ScannerConfiguration scannerConfiguration;
    
    public Scanner(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
        filterFactories = new FilterFactory[] {
            new FileSystemFilterFactory(scannerConfiguration),
            new UninfectableFilterFactory(),
            new ExecutableFilterFactory(scannerConfiguration),
            new DecompressFilterFactory()
        };
    }
    
    public void scan(ScanObject scanObject) throws VirusFoundException,
                                                   IOException {
        for (int i = 0; i < filterFactories.length; i++) {
            final Filter filter = filterFactories[i].getFilterFor(scanObject);
            if (filter != null) {
                try {
                    filter.filter(scanObject, this);
                } finally {
                    scanObject.dispose();
                }
                return;
            }
        }
        
        // what shall we do with this?
        new TrieScanFilter(scannerConfiguration.getTrie()).filter(scanObject,
                                                                  this);
        scanObject.dispose();
    }
    
    public ScannerConfiguration getScannerConfiguration() {
        return scannerConfiguration;
    }
}
