/*
 * $Id: CredoFile.java,v 1.2 2002/05/13 22:21:00 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.credo;

import java.util.*;
import java.util.jar.*;
import java.io.*;

/**
 * A file containing scanning information
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class CredoFile {
    public static final String VERSION =
        "$Id: CredoFile.java,v 1.2 2002/05/13 22:21:00 kurti Exp $";
    
    /** Filename extension of Credo-files */
    public static final String EXTENSION = ".credo";
    
    private final JarInputStream jarInputStream;
    
    public CredoFile(File file) throws CredoException {
        if (!file.exists()) {
            jarInputStream = null;
            throw new CredoException("Credo-File does not exist");
        }
        if (!file.isFile()) {
            jarInputStream = null;
            throw new CredoException("Credo-File is not a file");
        }
        
        try {
            jarInputStream = new JarInputStream(new FileInputStream(file));
        } catch( IOException ioe) {
            throw new CredoException(ioe.getMessage());
        }
    }
    
    public CredoFile(InputStream is) throws CredoException {
        if (is == null) {
            throw new CredoException("Credo-File not found");
        }
        try {
            jarInputStream = new JarInputStream(is);
        } catch (IOException ioe) {
            throw new CredoException(ioe.getMessage());
        }
    }
    
    /**
     * Returns all entries contained in the credo file
     *
     * @return Iterator of CredoEntry
     */
    public Iterator entries() {
        return new CredoEntryIterator(jarInputStream);
    }
}
