/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openantivirus.credo.CredoException;
import org.openantivirus.credo.CredoParser;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.RequestHandler;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.Trie;

public class ScannerDaemon {
    public static final String VERSION = "$Id: ScannerDaemon.java,v 1.11 2002/04/11 09:54:22 kurti Exp $";
    public static final String BINDNAME = "localhost";
    public static final int PORT = 8127;
    public static final String CREDO_DIRECTORY = "credo";
    private static final int MAX_BACKLOG = 50;
    private boolean isRunning;
    private final ScannerConfiguration scannerConfiguration = new ScannerConfiguration();

    public ScannerDaemon(String string, int n) throws CredoException, IOException {
        new CredoParser(this.scannerConfiguration, n).parse(new File(string != null ? string : CREDO_DIRECTORY));
        Trie trie = this.scannerConfiguration.getTrie();
        trie.prepare();
        System.out.println("Nodes: " + Node.getInstanceCount());
        int[] nArray = trie.getNodeDepths();
        int n2 = 0;
        while (n2 < nArray.length) {
            System.out.println(n2 + ": " + nArray[n2]);
            ++n2;
        }
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127, 50, InetAddress.getByName(BINDNAME));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                new Thread(new RequestHandler(serverSocket.accept(), this.scannerConfiguration.getTrie())).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 3;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].charAt(0) == '-') {
                String string2 = stringArray[n2].substring(1);
                if ("nosignature".equals(string2)) {
                    n = -1;
                } else if ("credolevel".equals(string2)) {
                    n = Integer.parseInt(stringArray[++n2]);
                } else {
                    System.err.println("Unknown parameter: " + stringArray[n2]);
                }
            } else {
                string = stringArray[n2];
            }
            ++n2;
        }
        try {
            new ScannerDaemon(string, n).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

