/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.credo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import org.openantivirus.credo.CredoEntryIterator;
import org.openantivirus.credo.CredoException;

public class CredoFile {
    public static final String VERSION = "$Id: CredoFile.java,v 1.1 2002/04/10 16:29:28 kurti Exp $";
    public static final String EXTENSION = ".credo";
    private final JarInputStream jarInputStream;

    public CredoFile(File file) throws CredoException {
        if (!file.exists()) {
            this.jarInputStream = null;
            throw new CredoException("Credo-File does not exist");
        }
        if (!file.isFile()) {
            this.jarInputStream = null;
            throw new CredoException("Credo-File is not a file");
        }
        try {
            this.jarInputStream = new JarInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new CredoException(iOException.getMessage());
        }
    }

    public CredoFile(InputStream inputStream) throws CredoException {
        if (inputStream == null) {
            throw new CredoException("Credo-File not found");
        }
        try {
            this.jarInputStream = new JarInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new CredoException(iOException.getMessage());
        }
    }

    public Iterator entries() {
        return new CredoEntryIterator(this.jarInputStream);
    }
}

