/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import org.openantivirus.scanner.PositionFoundEvent;
import org.openantivirus.scanner.PositionFoundListener;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.VirusFoundException;

public class StringVirusFinder {
    public static String VERSION = "$Id: StringVirusFinder.java,v 1.3 2002/01/12 13:48:04 kurti Exp $";

    public StringVirusFinder(Reader reader, StringFinder stringFinder, boolean bl) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = this.getClass().getResourceAsStream("/publickey.x509");
        while ((n = inputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        inputStream.close();
        try {
            String string;
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(stringBuffer.toString().getBytes());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf(61);
                if (n2 == -1) {
                    System.err.println("Malformed pattern line: " + string);
                    continue;
                }
                if (string.startsWith("==")) {
                    if (signature.verify(this.hexToString(string.substring(2)).getBytes())) {
                        System.out.println("Sucessfully verified signature.");
                        return;
                    }
                    System.err.println("Invalid signature. Exiting.");
                    System.exit(1);
                } else {
                    signature.update(string.getBytes());
                }
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                try {
                    stringFinder.addString(this.hexToString(string3), new StringVirusFoundListener(string2));
                }
                catch (Exception exception) {
                    System.err.println(string);
                    exception.printStackTrace();
                }
            }
            bufferedReader.close();
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            System.exit(1);
        }
        if (!bl) {
            System.err.println("No signature found. Read the manual on how to continue anyway. Exiting.");
            System.exit(1);
        }
    }

    protected String hexToString(String string) {
        if (string.length() % 2 != 0) {
            System.err.println("Malformed hexstring: " + string);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append((char)Integer.parseInt(string.substring(n, n + 2), 16));
            n += 2;
        }
        return stringBuffer.toString();
    }

    private class StringVirusFoundListener
    implements PositionFoundListener {
        private String virusName;
        private String pattern;

        public StringVirusFoundListener(String string) {
            this.virusName = string;
        }

        public void positionFound(PositionFoundEvent positionFoundEvent) throws VirusFoundException {
            throw new VirusFoundException(this.virusName);
        }
    }
}

