/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.RequestHandler;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.StringVirusFinder;
import org.openantivirus.scanner.Trie;

public class ScannerDaemon {
    public static final String VERSION = "$Id: ScannerDaemon.java,v 1.8 2002/01/12 14:08:02 kurti Exp $";
    public static final String BINDNAME = "localhost";
    public static final int PORT = 8127;
    private boolean isRunning;
    private Trie trie = new Trie();

    public ScannerDaemon(String string, boolean bl) throws IOException {
        new StringVirusFinder(new FileReader(string != null ? string : "virussignatures.txt.signed"), new StringFinder(this.trie), bl);
        this.trie.prepare();
        System.out.println("Nodes: " + Node.getInstanceCount());
        int[] nArray = this.trie.getNodeDepths();
        int n = 0;
        while (n < nArray.length) {
            System.out.println(n + ": " + nArray[n]);
            ++n;
        }
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127, 50, InetAddress.getByName(BINDNAME));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                new Thread(new RequestHandler(serverSocket.accept(), this.trie)).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                String string2 = stringArray[n].substring(1);
                if ("nosignature".equals(string2)) {
                    bl = true;
                } else {
                    System.err.println("Unknown parameter: " + stringArray[n]);
                }
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        try {
            new ScannerDaemon(string, bl).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

