/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.RequestHandler;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.StringVirusFinder;
import org.openantivirus.scanner.Trie;

public class ScannerDaemon {
    public static final String VERSION = "$Id: ScannerDaemon.java,v 1.6 2001/12/28 21:34:31 kurti Exp $";
    public static final String BINDNAME = "localhost";
    public static final int PORT = 8127;
    private boolean isRunning;
    private Trie trie = new Trie();

    public ScannerDaemon(String string) throws IOException {
        new StringVirusFinder(new FileReader(string != null ? string : "virussignatures.txt"), new StringFinder(this.trie));
        this.trie.prepare();
        System.out.println("Nodes: " + Node.getInstanceCount());
        int[] nArray = this.trie.getNodeDepths();
        int n = 0;
        while (n < nArray.length) {
            System.out.println(n + ": " + nArray[n]);
            ++n;
        }
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127, 50, InetAddress.getByName(BINDNAME));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                new Thread(new RequestHandler(serverSocket.accept(), this.trie)).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new ScannerDaemon(stringArray.length > 0 ? stringArray[0] : null).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

