/*
 * $Id: RecursiveFileFilter.java,v 1.3 2001/12/28 21:34:30 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.io.*;

/**
 * Recursively filters all files
 *
 * @author  Kurt Huwig
 * @version $Revision: 1.3 $
 */
public class RecursiveFileFilter {
    public static final String VERSION =
        "$Id: RecursiveFileFilter.java,v 1.3 2001/12/28 21:34:30 kurti Exp $";

    private StreamFileFilter sff;
    
    public RecursiveFileFilter(StreamFileFilter sff) {
        this.sff = sff;
    }
    
    public void filter(File f) throws VirusFoundException, IOException {
        if (f.isDirectory()) {
            File[] afFiles = f.listFiles();
            for (int i = 0; i < afFiles.length; i++) {
                filter(afFiles[ i ]);
            }
        } else {
            long lStart = System.currentTimeMillis();
            sff.filter(new RandomAccessFile(f, "r"));
            System.out.println("Scanned " + f.getCanonicalPath() + "; took "
                               + (System.currentTimeMillis() - lStart) + "ms");
        }
    }
}
