/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openantivirus.scanner.PositionFoundEvent;
import org.openantivirus.scanner.PositionFoundListener;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.VirusFoundException;

public class StringVirusFinder {
    public static String VERSION = "$Id: StringVirusFinder.java,v 1.2 2001/12/28 16:32:23 kurti Exp $";

    public StringVirusFinder(Reader reader, StringFinder stringFinder) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                System.err.println("Malformed pattern line: " + string);
                continue;
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            if (string3.length() % 2 != 0) {
                System.err.println("Malformed pattern: " + string);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < string3.length()) {
                ++n;
                stringBuffer.append((char)Integer.parseInt(string3.substring(n3, n3 + 2), 16));
                n3 += 2;
            }
            try {
                stringFinder.addString(stringBuffer.toString(), new StringVirusFoundListener(string2));
            }
            catch (Exception exception) {
                System.err.println(string);
                exception.printStackTrace();
            }
        }
        bufferedReader.close();
    }

    private class StringVirusFoundListener
    implements PositionFoundListener {
        private String virusName;
        private String pattern;

        public StringVirusFoundListener(String string) {
            this.virusName = string;
        }

        public void positionFound(PositionFoundEvent positionFoundEvent) throws VirusFoundException {
            throw new VirusFoundException(this.virusName);
        }
    }
}

