/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openantivirus.scanner.StreamScanner;
import org.openantivirus.scanner.Trie;
import org.openantivirus.scanner.TrieScanner;
import org.openantivirus.scanner.VirusFoundException;

public class SequentialStreamFilter {
    public static String VERSION = "$Id: SequentialStreamFilter.java,v 1.2 2002/01/04 02:31:25 kurti Exp $";
    private static final int BLOCK_SIZE = 4096;
    private StreamScanner ss;

    public SequentialStreamFilter(Trie trie) {
        this.ss = new TrieScanner(trie);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filter(InputStream inputStream, OutputStream outputStream) throws VirusFoundException, IOException {
        block10: {
            block9: {
                this.ss.reset();
                try {
                    byte[] byArray = new byte[12288];
                    int n = this.fillBuffer(inputStream, byArray, 0, byArray.length);
                    if (n == -1) {
                        Object var8_5 = null;
                        break block9;
                    }
                    if (n < byArray.length) {
                        this.ss.update(byArray, 0, n, 0, 0);
                        if (outputStream != null) {
                            outputStream.write(byArray, 0, n);
                        }
                        break block10;
                    }
                    this.ss.update(byArray, 0, 8192, 0, 4096);
                    if (outputStream != null) {
                        outputStream.write(byArray, 0, 8192);
                    }
                    int n2 = 8192;
                    int n3 = 0;
                    do {
                        if ((n = this.fillBuffer(inputStream, byArray, n3, 4096)) == -1) continue;
                        this.ss.update(byArray, n2, 4096, 4096, n);
                        if (outputStream != null) {
                            outputStream.write(byArray, n2, 4096);
                        }
                        n2 = n3;
                        n3 += 4096;
                        n3 %= 12288;
                    } while (n == 4096);
                    if (n == -1) break block10;
                    this.ss.update(byArray, n2, n, 4096, 0);
                    if (outputStream != null) {
                        outputStream.write(byArray, n2, n);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    inputStream.close();
                    throw throwable;
                }
            }
            inputStream.close();
            return;
        }
        Object var8_6 = null;
        inputStream.close();
    }

    protected int fillBuffer(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = inputStream.read(byArray, n + n4, n2 - n4)) != -1) continue;
            return n4 == 0 ? -1 : n4;
        } while ((n4 += n3) < n2);
        return n4;
    }
}

