/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openantivirus.scanner.StreamFileFilter;
import org.openantivirus.scanner.VirusFoundException;

public class RecursiveFileFilter {
    public static final String VERSION = "$Id: RecursiveFileFilter.java,v 1.3 2001/12/28 21:34:30 kurti Exp $";
    private StreamFileFilter sff;

    public RecursiveFileFilter(StreamFileFilter streamFileFilter) {
        this.sff = streamFileFilter;
    }

    public void filter(File file) throws VirusFoundException, IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.filter(fileArray[n]);
                ++n;
            }
        } else {
            long l = System.currentTimeMillis();
            this.sff.filter(new RandomAccessFile(file, "r"));
            System.out.println("Scanned " + file.getCanonicalPath() + "; took " + (System.currentTimeMillis() - l) + "ms");
        }
    }
}

