package org.openantivirus.util;

import java.io.*;
import java.util.*;

import org.openantivirus.ole.*;

/**
 * Tries to delete as much as possible of a file so that the virus-scanner
 * still detects the virus
 *
 * @author  Kurt Huwig
 * @version $Id: PatternFinder.java,v 1.8 2001/09/15 08:20:29 kurti Exp $
 */
public class PatternFinder {

  private String sFilename;
  private final static String
    CLEARED_SUFFIX = ".cleared",
    TEST_FILE      = "test.txt";
  
  private final static int
    MINIMUM_SIZE   = 1,
    BUFFER_LENGTH  = 16384;
  
  private final char FILL_CHAR = '*';
  
  private String sClearFile;
  private final byte[] abOverwrite;
  
  private String[] asScanArgs;
  
  private Runtime runtime = Runtime.getRuntime();
  
  private int iHash, iInfectedHash;
  
  /**
   * Helper class
   */
  private class InfectionArea {
    long lStart, lEnd;
    
    InfectionArea( long lStart, long lEnd ) {
      this.lStart = lStart;
      this.lEnd   = lEnd;
    }
  }
  
  private Vector vInfected = new Vector();
  
  public PatternFinder( String sScannerCommand, String sFilename ) {
    this.sFilename       = sFilename;
    sClearFile = sFilename + CLEARED_SUFFIX;
    
    StringTokenizer st = new StringTokenizer( sScannerCommand );
    asScanArgs = new String[ st.countTokens() + 1 ];
    for( int i = 0; st.hasMoreTokens(); i++ ) {
      asScanArgs[ i ] = st.nextToken();
    }
    abOverwrite = new byte[ BUFFER_LENGTH ];
    
    for( int i = 0; i < abOverwrite.length; i++ ) {
      abOverwrite[ i ] = (byte) FILL_CHAR;
    }
  }
  
  public void find() throws IOException {
    System.out.println( "Clearing " + sFilename + "..." );
    
    long lTotalLength = createClearFile();
    long lClearLength;
    
    asScanArgs[ asScanArgs.length - 1 ] = sFilename + CLEARED_SUFFIX;
    if( !infected() ) {
      System.err.println( "ERROR: File is not infected" );
      return;
    }
    asScanArgs[ asScanArgs.length - 1 ] = TEST_FILE;
    iInfectedHash = iHash;
    
    int[] aiMacroPageIndices = null;
    try {
      OLEReader oleReader = new OLEReader( sFilename );
      aiMacroPageIndices = oleReader.getPageIndices();
      lClearLength = oleReader.getMacroSize();
      System.out.println( "File is an OLE document" );
    } catch( IOException ioe ) {
      // file is not an OLE file, good
      lClearLength = lTotalLength;
    }
    
    System.out.print(
      "...10...20...30...40...50...60...70...80...90..100%\r"
    );
    System.out.flush();
    
    long lPos = 0, lInfectionStart = 0;
    double dPercent   = lClearLength / 50.0;
    long lNextPercent = (long) dPercent;
    int iCurrentPercent = 0;
    long lAdvance = 1;
    boolean bClearing = true;
    boolean isInfected = false;

    long lStartClear = 0;
    while( lPos < lClearLength ) {
      if( aiMacroPageIndices != null ) {
        int
          iPageNr = (int) lPos / OLEPage.SIZE,
          iPosInPage = (int) lPos % OLEPage.SIZE;
        
        // we have to stay in the page!
        if( iPosInPage + lAdvance > OLEPage.SIZE ) {
          lAdvance = OLEPage.SIZE - iPosInPage;
        }
        lStartClear = aiMacroPageIndices[ iPageNr ] * OLEPage.SIZE + iPosInPage;
        //System.out.println( "Clear: " + lStartClear + "-" + (lStartClear + lAdvance ) + " (" + lAdvance + ")" );
      } else {
        lStartClear = lPos;
      }
      if( tryClear( lStartClear, lStartClear + lAdvance ) ) {
        if( !bClearing ) {
          bClearing = true;
          ( (InfectionArea)vInfected.lastElement() ).lEnd = lStartClear - 1;
        }
        lPos += lAdvance;
        lAdvance *= 2;
        if( lPos + lAdvance > lClearLength ) {
          lAdvance = lClearLength - lPos;
        }
      } else {
        if( lAdvance == 1 ) {
          isInfected = true;
          if( bClearing ) {
            bClearing = false;
            lInfectionStart = lPos;
            vInfected.addElement( new InfectionArea( lStartClear, lStartClear ) );
          }
          lPos++;
        } else {
          lAdvance /= 2;
        }
      }
      if( lPos >= lNextPercent ) {
        while( lPos >= lNextPercent ) {
          System.out.print( isInfected ? 'I' : '_' );
          System.out.flush();
          lNextPercent = (long) ( dPercent * ++iCurrentPercent );
        }
        isInfected = false;
      }
    }
    System.out.println();
    if( !bClearing ) {
      ( (InfectionArea)vInfected.lastElement() ).lEnd = lStartClear - 1;
    }
    for( Enumeration e = vInfected.elements(); e.hasMoreElements(); ) {
      InfectionArea ia = (InfectionArea) e.nextElement();
      System.out.print( "Infected: " + ia.lStart + "-" + ia.lEnd + "=" );
      codedump( ia.lStart, ia.lEnd );
    }
  }
  
  private long createClearFile() throws IOException {
    InputStream is = new FileInputStream( sFilename );
    OutputStream os = new FileOutputStream( sClearFile );
    byte[] ab = new byte[ BUFFER_LENGTH ];
    int iLength;
    long lTotalLength = 0;
    while( ( iLength = is.read( ab ) ) != -1 ) {
      os.write( ab, 0, iLength );
      lTotalLength += iLength;
    }
    os.close();
    is.close();
    
    return lTotalLength;
  }
    
  private boolean tryClear( long lStart, long lEnd ) throws IOException {
    clearArea( lStart, lEnd );
    if( infected() && iHash == iInfectedHash ) {
      InputStream is = new FileInputStream( TEST_FILE );
      OutputStream os = new FileOutputStream( sClearFile );
      byte[] ab = new byte[ BUFFER_LENGTH ];
      int iLength;
      while( ( iLength = is.read( ab ) ) != -1 ) {
        os.write( ab, 0, iLength );
      }
      os.close();
      is.close();
      /*
      System.out.println(
        "Cleared: " + Long.toHexString( lStart ) + "-" +
        Long.toHexString( lEnd - 1 )
      );*/
      return true;
    } else {
      return false;
    }
  }
  
  private void clearArea( long lStart, long lEnd ) throws IOException {
    InputStream is = new FileInputStream( sClearFile );
    OutputStream os = new FileOutputStream( TEST_FILE );
    
    byte[] ab = new byte[ BUFFER_LENGTH ];
    long lPos = 0;
    int iLength;
    
    while( lPos < lStart &&
           ( iLength = is.read(
               ab, 0, Math.min( BUFFER_LENGTH, (int) (lStart - lPos ) )
             )
           ) != -1 ) {
      os.write( ab, 0, iLength );
      lPos += iLength;
    }
    
    while( lPos < lEnd &&
           ( iLength = is.read(
               ab, 0, Math.min( BUFFER_LENGTH, (int) (lEnd - lPos ) )
             )
           ) != -1 ) {
      os.write( abOverwrite, 0, iLength );
      lPos += iLength;
    }
    
    while( ( iLength = is.read( ab ) ) != -1 ) {
      os.write( ab, 0, iLength );
    }
    
    os.close();
    is.close();
  }
  
  private boolean infected() {
    try {
      Process p = runtime.exec( asScanArgs );
      int iExit = p.waitFor();
      InputStream is = p.getInputStream();
      iHash = 0xDEADBEEF;
      int iByte;
      while( ( iByte = is.read() ) != -1 ) {
        iHash *= iByte;
        iHash += iByte;
      }
      is.close();
      p.getOutputStream().close();
      p.getErrorStream().close();
      return iExit != 0;
    } catch( Exception e ) {
      e.printStackTrace();
      return false;
    }
  }
  
  private void codedump( long lStart, long lEnd ) throws IOException {
    RandomAccessFile ras = new RandomAccessFile( sClearFile, "r" );
    ras.seek( lStart );
    do {
      String sHex = Integer.toHexString( ras.read() );
      System.out.print( ( "0" + sHex ).substring( sHex.length() - 1 ) );
    } while( ++lStart <= lEnd );
    ras.close();
    System.out.println();
  }
  
  public static void main( String[] asParams ) {
    if( asParams.length < 2 ) {
      System.err.println(
        "Usage: org.openantivirus.util.PatternFinder <scannercommand> " +
        "<filename> [<filename>...]"
      );
      System.exit( 1 );
    }
    
    try {
      for( int i = 1; i < asParams.length; i++ ) {
        new PatternFinder( asParams[ 0 ], asParams[ i ] ).find();
      }
    } catch( Exception e ) {
      e.printStackTrace();
    }
  }
}
