/*
 * $Id: ScannerDaemon.java,v 1.4 2001/12/12 23:59:38 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

package org.openantivirus.scanner;

import java.net.*;
import java.io.*;
import java.util.StringTokenizer;

/**
 * Listens on a port to incoming scan request. Request is of the form
 *
 *  SCAN <filename><newline>
 *
 * Answers with
 *
 *  OK<newline>
 *
 * or
 *
 *  FOUND: <virusname> <virusname> <virusname>...<newline>
 *
 * @author  Kurt Huwig
 * @version $Revision: 1.4 $
 */
public class ScannerDaemon {
    public static final String VERSION =
        "$Id: ScannerDaemon.java,v 1.4 2001/12/12 23:59:38 kurti Exp $";
    
    public final static int PORT = 8127;
    
    private boolean isRunning;
    private RecursiveFileFilter rff;
    
    public ScannerDaemon(String sSignatureFile) throws IOException {
        Trie trie = new Trie();
        
        new StringVirusFinder(new FileReader(sSignatureFile != null ?
                                             sSignatureFile :
                                             "virussignatures.txt"),
                              new StringFinder(trie));
        
        trie.prepare();
        rff = new RecursiveFileFilter(new StreamFileFilter(
            new TrieScanner(trie)));
    }
    
    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(PORT);
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        
        isRunning = true;
        while (isRunning) {
            try {
                Socket clientSocket = serverSocket.accept();
                BufferedReader br = new BufferedReader(new InputStreamReader(
                    clientSocket.getInputStream()));
                
                StringTokenizer st = new StringTokenizer(br.readLine());
                
                st.nextToken(); // hopefully 'SCAN'
                String sFile = st.nextToken();
                
                String sResult;
                try {
                    rff.filter(new File(sFile));
                    sResult = "OK\n";
                } catch (VirusFoundException vfe) {
                    sResult = vfe.getMessage() + "\n";
                }
                
                OutputStream os = clientSocket.getOutputStream();
                os.write(sResult.getBytes());
                os.close();
                br.close();
                clientSocket.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    public static void main(String[] args) {
        try {
            new ScannerDaemon(args.length > 0 ? args[ 0 ] : null).start();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}
