/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ole;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openantivirus.ole.OLEDirectory;
import org.openantivirus.ole.OLEDirectoryEntry;
import org.openantivirus.ole.OLEFile;
import org.openantivirus.ole.OLEPageList;
import org.openantivirus.ole.OLEPageMap;

public class OLEReader {
    private ArrayList listMacroPages = new ArrayList();
    private int iMacroSize;

    public OLEReader(String string) throws IOException {
        Object object;
        OLEFile oLEFile = new OLEFile(new File(string));
        try {
            object = oLEFile.getFileInformationBlock();
        }
        catch (IOException iOException) {
            oLEFile.close();
            throw iOException;
        }
        object = oLEFile.getBigBlockPageMap();
        OLEPageMap oLEPageMap = oLEFile.getSmallBlockPageMap();
        OLEDirectory oLEDirectory = oLEFile.getDirectory();
        OLEPageList oLEPageList = null;
        int n = 0;
        while (n < oLEDirectory.size()) {
            OLEDirectoryEntry oLEDirectoryEntry = oLEDirectory.getDirectoryEntry(n);
            if (oLEDirectoryEntry.getName().equals("Root Entry")) {
                oLEPageList = ((OLEPageMap)object).getPageList(oLEDirectoryEntry.getStart());
            } else if (oLEDirectoryEntry.getName().equals("ThisDocument")) {
                this.iMacroSize = oLEDirectoryEntry.getSize();
                OLEPageList oLEPageList2 = oLEDirectoryEntry.getSize() >= 4096 ? ((OLEPageMap)object).getPageList(oLEDirectoryEntry.getStart()) : oLEPageMap.getPageList(oLEDirectoryEntry.getStart());
                int n2 = oLEDirectoryEntry.getSize();
                Iterator iterator = oLEPageList2.iterator();
                while (n2 > 0 && iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    if (oLEDirectoryEntry.getSize() < 4096) {
                        n3 = oLEPageList.getPageIndex(n3);
                    }
                    this.listMacroPages.add(new Integer(n3));
                    n2 -= 512;
                }
            }
            ++n;
        }
        oLEFile.close();
    }

    public int getMacroSize() {
        return this.iMacroSize;
    }

    public int[] getPageIndices() {
        int[] nArray = new int[this.listMacroPages.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)this.listMacroPages.get(n) + 1;
            ++n;
        }
        return nArray;
    }
}

