(***** Implantation du graphisme pour le frontal CAMLWIN
  Ce fichier est la version CAMLWIN de la bibliothque de routines
  graphiques.
  *)

(*** Modifications ****)
(* 6/4/96
    Premire version,adapte directement de la version DOS
    *)
  
(* 15/8/96
    optimisation des routines graphiques
    *)
    
(* 13/10/96
    supprim les accents dans les dfinitions (problmes avec CAMLWIN)
    *)

(**** Implantation ****) 
(* les fonctions qui suivent ne sont l que pour des raisons de 
  compatibilit avec la version DOS 
  Cela permet d'avoir les mmes sources qui tournent dans les deux 
  environnements 
  *)
  
let graph_flush () = ();;
let graph_display (a:string) = ();;
let graph_display_each l = do_list graph_display l;;

(* la position du curseur graphique
   maintenue uniquement par les fonctions de ce fichier.
   Il n'existe actuellement aucun dialogue du frontal -> CAML, qui
   pourrait permettre de connatre la VRAIE position du curseur... 
   *)
let x_graph_cursor = ref 0.
and y_graph_cursor = ref 0.;;

(**** les routines de base. Autodocumentes *)
let graph_clear () =
  graphics__clear_graph ();;

(* pour la gestion des chelles *)
let wmtgraph_xmin = ref (-5.0)
and wmtgraph_xmax = ref 5.
and wmtgraph_ymin = ref (-5.)
and wmtgraph_ymax = ref 5.;;

let graph_scale xmin xmax ymin ymax = 
  wmtgraph_xmin := xmin;
  wmtgraph_xmax := xmax;
  wmtgraph_ymin := ymin;
  wmtgraph_ymax := ymax;;

 (********pb de div par  zro : pas d'exception leve *************)

(* les fonctions de transformation des coordonnes *)
let x_scale = fun dx ->
  int_of_float(dx *. float_gsx)
  where
    float_gsx = 
      float_of_int(graphics__size_x()) /. (!wmtgraph_xmax -. !wmtgraph_xmin);;

let x_transform x =
  x_scale (x -. !wmtgraph_xmin);;

let y_scale = fun dy ->
  int_of_float(dy *. float_gsy)
  where
    float_gsy = float_of_int(graphics__size_y()) /. (!wmtgraph_ymax -. !wmtgraph_ymin);;

let y_transform y =
  y_scale (y -. !wmtgraph_ymin);;


(* les fonctions de trac *)
let graph_moveto x y = 
  x_graph_cursor := x;
  y_graph_cursor := y;
  graphics__moveto (x_transform x) (y_transform y);;

let graph_plot x y = 
  x_graph_cursor := x;
  y_graph_cursor := y;
  graphics__plot (x_transform x) (y_transform y);;


let graph_lineto x y = 
  graph_moveto !x_graph_cursor !y_graph_cursor;
  x_graph_cursor := x;
  y_graph_cursor := y;
  graphics__lineto (x_transform x) (y_transform y);;

let graph_boxto x y =
  let old_x = !x_graph_cursor
  and old_y = !y_graph_cursor
  in
    begin
      graph_moveto !x_graph_cursor !y_graph_cursor;
      graph_lineto !x_graph_cursor y;
      graph_lineto x y;
      graph_moveto old_x old_y;
      graph_lineto x !y_graph_cursor;
      graph_lineto x y;
      ()
    end;;  

let graph_boxfullto x y = 
  graph_moveto !x_graph_cursor !y_graph_cursor;
  graphics__fill_rect 
    (x_transform !x_graph_cursor)
    (y_transform !y_graph_cursor)
    (x_scale (x -. !x_graph_cursor))
    (y_scale (y -. !y_graph_cursor));
  x_graph_cursor := x;
  y_graph_cursor := y;
  ();;

let graph_circle x y r = 
  graphics__draw_ellipse
    (x_transform x) (y_transform y) 
    (x_scale r) (y_scale r);
  x_graph_cursor := x;
  y_graph_cursor := y;
  ();;

let graph_color r g b = 
  graphics__set_color (graphics__rgb r g b);;

let graph_drawtext text =
  graph_moveto !x_graph_cursor !y_graph_cursor;
  graphics__draw_string text;;

(* Cette fonction n'a pas d'quivalent dans le noyau graphique de CAML *)
let graph_floodfill x y = 
  ();;

(* initialisation du graphisme *)
let graph_init () = 
  graphics__open_graph "";
  graph_clear();
  graph_scale (-2.) 2. (-2.) 2.;
  graph_moveto 0. 0.;
  graph_color 0 0 0;;

(* le monde des tortues, en Franais ! *)
let deg_par_radian = 180. /. (4. *. atan 1.);;

(* les commandes reconnues par la tortue de base *)
type ordre_tortue = 
   origine| va_en| avance| recule| 
   tourne_gauche| tourne_droite|
   fixe_cap| leve_crayon| baisse_crayon |
   etat
   ;;

type argument_tortue = 
  a_rien of unit | a_nombre of float | a_coord of float * float;;

type etat_crayon = bas | haut;;

type etat_tortue = 
  {x : float; y : float; cap : float; crayon : etat_crayon};;
  
type resultat_tortue = 
  r_rien of unit | r_etat of etat_tortue;;

(* la gestion des erreurs *)
exception erreur_tortue;;

(* une tortue est une fonction qui, en recevant une commande renvoie une
   fonction charge d'valuer l'argument de la commande.*)
type tortue == ordre_tortue -> argument_tortue -> resultat_tortue;;

(* le crateur de tortue *)
let cree_tortue () =
  let x = ref 0.        (* les variables d'tat de la bte *)
  and y = ref 0.
  and cap = ref 0.
  and crayon = ref bas
  in function        
    etat ->
      (fun (a_rien ()) ->
        r_etat {x = !x; y = !y; cap = !cap; crayon= !crayon}
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | origine ->
      (fun (a_rien ()) -> 
        x:= 0.; y:= 0.; cap:= 0.;
        graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | va_en ->
      (fun (a_coord (xd, yd)) ->
        graph_moveto !x !y;
        x:= xd;
        y:= yd;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | avance ->
      (fun (a_nombre longueur) ->
        graph_moveto !x !y;
        x:= !x +. longueur *. cos !cap;
        y:= !y +. longueur *. sin !cap;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | recule ->
      (fun (a_nombre longueur) ->
        graph_moveto !x !y;
        x:= !x -. longueur *. cos !cap;
        y:= !y -. longueur *. sin !cap;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | tourne_gauche ->
      (fun (a_nombre angle) ->
        cap:= !cap +. angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | tourne_droite ->
      (fun (a_nombre angle) ->
        cap:= !cap -. angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | fixe_cap ->
      (fun (a_nombre angle) ->
        cap:= angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | leve_crayon ->
      (fun (a_rien ()) ->
        crayon:= haut;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | baisse_crayon ->
      (fun (a_rien ()) ->
        crayon:= bas;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    ;;

(* l'interface "procdurale" commode d'une tortue, avec forage de type *)
let retourne_etat (tortue : tortue) =
  match tortue etat (a_rien ()) with
    r_etat x -> x
    | _ -> (raise erreur_tortue "Argument incorrect");;


let org (tortue:tortue) =
  tortue origine (a_rien ()); ();;

let va (tortue:tortue) x y = 
  tortue va_en (a_coord (x, y)); ();;

let av (tortue:tortue) l = 
  tortue avance (a_nombre l); ();;

let re (tortue:tortue) l = 
  tortue recule (a_nombre l); ();;

let tg (tortue:tortue) a = 
  tortue tourne_gauche (a_nombre a); ();;

let td (tortue:tortue) a = 
  tortue tourne_droite (a_nombre a); ();;

let fc (tortue:tortue) c = 
  tortue fixe_cap (a_nombre c); ();;

let lc (tortue:tortue) =
  tortue leve_crayon (a_rien ()); ();;

let bc (tortue:tortue) =
  tortue baisse_crayon (a_rien ()); ();;
