(* This file is created with Camldsgn *)

#open "windows";;
#open "camlwin";;






let ColorWin_def = 
{
  win_left     = 20;
  win_top      = 170;
  win_width    = 100;
  win_height   = 75;
  win_id       = gr_undef_window;
  win_name     = "Choose Color";
  win_state    = Destroyed
};;

let choose_color = 
{
  gb_window   = ColorWin_def;
  gb_left     = 20;
  gb_top      = 62;
  gb_width    = 62;
  gb_height   = 32;
  gb_btwidth  = 15;
  gb_btheight = 10;
  gb_delta    = 4;
  gb_button   = 5;
  gb_dir      = Vertical;
  gb_name     = [|
                  bitmap_type (make_image (make_matrix 10 10 blue));
                  bitmap_type (make_image (make_matrix 10 10 red));
                  bitmap_type (make_image (make_matrix 10 10 white));
                  bitmap_type (make_image (make_matrix 10 10 yellow));
                  bitmap_type (make_image (make_matrix 10 10 green));
                  bitmap_type (make_image (make_matrix 10 10 magenta))
                |];
  gb_callback = gr_do_nothing
};;

let color_title = 
{
  pt_window   = ColorWin_def;
  pt_left     = 32;
  pt_top      = 72;
  pt_name     = "Title"
};;

let color_help = 
{
  hl_window   = ColorWin_def;
  hl_help     = "Press Ok when finished"
};;

let ok_button = 
{
  bt_window   = ColorWin_def;
  bt_left     = 37;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let ColorWin = 
{
  win_def      = ColorWin_def;
  win_objects  = [
                  g_grpbut    choose_color;
                  g_prompt    color_title;
                  g_helpbar   color_help;
                  g_button    ok_button
                 ]
;
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;

let CloseColor Obj Event =
  gr_erase_window ColorWin.win_def;
  true;;

ok_button.bt_callback <- CloseColor;;


