function test_skewHamileig_nb
% Function for testing the routine DGHUTP (block code). Random matrices of all
% orders m = 1:20 are used and the relative errors are checked.

%
%   Contributor:
%   V. Sima, July 2013.
%
%   Revisions:
%   M. Voigt, July 2013.
%   V. Sima, June 2014, July 2014.
%

disp(' ')
disp('Random tests of the routine DGHUTP')
disp(' ')

if ~exist( 'nb', 'var' ) || isempty( nb ),  nb = 32;  end

count = 0;
max_err = 0.0;
tole = sqrt( eps );
tol  = 10*tole;

job0   = 0;  job1   = 1;
cmpq10 = 0;  cmpq11 = 1;  cmpq12 = 2;
cmpq20 = 0;  cmpq21 = 1;  cmpq22 = 2;

% Check default values.

m = 4;  n = 2*m;
A = rand( m );  DE = rand( m, m+1 );
C = rand( m );  VW = rand( m, m+1 );
%
D = triu( DE(:,2:end), 1 );  E = tril( DE(:,1:m), -1 );
V = triu( VW(:,2:end) );     W = tril( VW(:,1:m) );
%
S = [ A D-D'; E-E' A' ];
H = [ C V+triu( V, 1 )'; W+tril( W, -1 )' -C' ];
J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
%
[ Q, r ] = qr( S );
%
[ Alphar,   Alphai,   Beta,   Ao,   Do,   Bo,  Fo,  C1o,  Vo,  C2o,  Q1r, Q2r ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1, cmpq12, Q, cmpq22 );
[ Alphar1,  Alphai1,  Beta1,  Ao1,  Do1,  Bo1, Fo1, C1o1, Vo1, C2o1, Q11, Q21 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1, cmpq11, cmpq21 );
[ Alphar2,  Alphai2,  Beta2,  Ao2,  Do2,  Bo2, Fo2, C1o2, Vo2, C2o2, Q12 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1, cmpq11 );
[ Alphar3,  Alphai3,  Beta3,  Ao3,  Do3,  Bo3, Fo3, C1o3, Vo3, C2o3 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1, cmpq10, cmpq20 );
[ Alphar4,  Alphai4,  Beta4,  Ao4,  Do4,  Bo4, Fo4, C1o4, Vo4, C2o4 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1, cmpq10 );
[ Alphar5,  Alphai5,  Beta5,  Ao5,  Do5,  Bo5, Fo5, C1o5, Vo5, C2o5 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar6,  Alphai6,  Beta6,  Ao6,  Do6,  Bo6, Fo6, C1o6, Vo6 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar7,  Alphai7,  Beta7,  Ao7,  Do7,  Bo7, Fo7, C1o7 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar8,  Alphai8,  Beta8,  Ao8,  Do8,  Bo8, Fo8 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar9,  Alphai9,  Beta9,  Ao9,  Do9,  Bo9 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar10, Alphai10, Beta10, Ao10, Do10 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar11, Alphai11, Beta11, Ao11 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar12, Alphai12, Beta12 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job1 );
[ Alphar13, Alphai13, Beta13 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job0 );
[ Alphar14, Alphai14, Beta14 ] = ...
                            skewHamileig_nb( A, DE, C, VW );
%
err = max( [ norm( Alphar - Alphar1  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai1  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta1    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar2  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai2  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta2    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar3  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai3  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta3    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar4  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai4  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta4    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar5  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai5  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta5    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar6  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai6  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta6    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar7  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai7  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta7    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar8  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai8  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta8    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar9  )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai9  )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta9    )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar10 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai10 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta10   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar11 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai11 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta11   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar12 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai12 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta12   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar13 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai13 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta13   )/max( 1, norm( Beta   ) ), ...
             norm( Alphar - Alphar14 )/max( 1, norm( Alphar ) ), ...
             norm( Alphai - Alphai14 )/max( 1, norm( Alphai ) ), ...
             norm( Beta   - Beta14   )/max( 1, norm( Beta   ) ) ] );
%
err = max( [ norm( Ao  - Ao1,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do1,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo1,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo1,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo1,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o1, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( C2o - C2o1, 1 )/max( 1, norm( C2o, 1 ) ), ...
             norm( Ao  - Ao2,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do2,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo2,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo2,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo2,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o2, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( C2o - C2o2, 1 )/max( 1, norm( C2o, 1 ) ), ...
             norm( Ao  - Ao3,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do3,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo3,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo3,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo3,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o3, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( C2o - C2o3, 1 )/max( 1, norm( C2o, 1 ) ), ...
             norm( Ao  - Ao4,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do4,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo4,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo4,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo4,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o4, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( C2o - C2o4, 1 )/max( 1, norm( C2o, 1 ) ), ...
             norm( Ao  - Ao5,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do5,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo5,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo5,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo5,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o5, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( C2o - C2o5, 1 )/max( 1, norm( C2o, 1 ) ), ...
             norm( Ao  - Ao6,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do6,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo6,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo6,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Vo  - Vo6,  1 )/max( 1, norm( Vo,  1 ) ), ...
             norm( C1o - C1o6, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( Ao  - Ao7,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do7,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo7,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo7,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( C1o - C1o7, 1 )/max( 1, norm( C1o, 1 ) ), ...
             norm( Ao  - Ao8,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do8,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo8,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Fo  - Fo8,  1 )/max( 1, norm( Fo,  1 ) ), ...
             norm( Ao  - Ao9,  1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do9,  1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Bo  - Bo9,  1 )/max( 1, norm( Bo,  1 ) ), ...
             norm( Ao  - Ao10, 1 )/max( 1, norm( Ao,  1 ) ), ...
             norm( Do  - Do10, 1 )/max( 1, norm( Do,  1 ) ), ...
             norm( Ao  - Ao11, 1 )/max( 1, norm( Ao,  1 ) ), ...
             err ] );
erq = max( [ norm(      Q*Q11 - Q1r ), ... 
             norm( J*Q*J'*Q21 - Q2r ), ...
             norm(        Q11 - Q12 ) ] )/n;
if err ~= 0 || erq > eps, 
    disp( 'Check default values:' )
    if err > tol || erq > tole,  
        disp( 'Failed 1' ),  
    else
        disp( 'The most accurate tests (err = 0, erq <= eps) are not satisfied' ) 
        disp( [ 'But err = ', num2str( err), ' and erq = ', num2str( erq) ] )
    end
    disp( ' ' ) 
end          
%
% Check functionality.
%
% Using rand.
%
for m = 0 : 20,
   for nb = 1 : max( m, 1 ),
      n = 2*m;
      A = rand( m );  DE = rand( m, m+1 );
      C = rand( m );  VW = rand( m, m+1 );
      %
      D = triu( DE(:,2:end), 1 );  E = tril( DE(:,1:m), -1 );
      V = triu( VW(:,2:end) );     W = tril( VW(:,1:m) );
      %
      S = [ A D-D'; E-E' A' ];
      H = [ C V+triu( V, 1 )'; W+tril( W, -1 )' -C' ];
      J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
      %
      evm = eig( H, S );
      if isreal( evm ),
         evp = evm( evm > 0 );
      else
         evp = union( evm( imag( evm ) == 0 & real( evm > 0 ) ), ...
                      evm( imag( evm ) > 0 ) );
      end
      %
      for job = 0 : 1,
         count = count + 1;
         [ Alphar, Alphai, Beta, Ao, Do, Bo, Fo, C1o, Vo, C2o, Q1, Q2 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job, cmpq11, cmpq21 );
         ev  = ( Alphar + Alphai*1i )./Beta;
         err = norm( ev - cmpoles( ev, evp ) )/max( 1, norm( evp ) );
         if err > tol,  disp( 'Failed 2' ),  return,  end
         max_err = max( max_err, err );
         Dot = triu( Do, 1 );
         Fot = triu( Fo, 1 );
         %
         So = [ Ao Dot-Dot'; zeros( m )  Ao' ];
         To = [ Bo Fot-Fot'; zeros( m )  Bo' ];
         Ho = [ C1o      Vo; zeros( m ) C2o' ];
         errm = max( [ norm( So - Q1'*S*J*Q1*J', 1 )/max( norm( So, 1 ), 1 ), ...
                       norm( To - J'*Q2'*J*S*Q2, 1 )/max( norm( To, 1 ), 1 ), ...
                       norm( Ho - Q1'*H*Q2,      1 )/max( norm( Ho, 1 ), 1 ) ] );
         if errm > tol,  disp( 'Failed 3' ),  return,  end
         max_err = max( max_err, errm );
      end
   end
end
%
% Using randn.
%
for m = 0 : 20,
   for nb = 1 : max( m, 1 ),
      n = 2*m;
      A = randn( m );  DE = randn( m, m+1 );
      C = randn( m );  VW = randn( m, m+1 );
      %
      D = triu( DE(:,2:end), 1 );  E = tril( DE(:,1:m), -1 );
      V = triu( VW(:,2:end) );     W = tril( VW(:,1:m) );
      %
      S = [ A D-D'; E-E' A' ];
      H = [ C V+triu( V, 1 )'; W+tril( W, -1 )' -C' ];
      J = [ zeros( m ) eye( m ); -eye( m ) zeros( m ) ];
      %
      evm = eig( H, S );
      if isreal( evm ),
         evp = evm( evm > 0 );
      else
         evp = union( evm( imag( evm ) == 0 & real( evm > 0 ) ), ...
                      evm( imag( evm ) > 0 ) );
      end
      %
      for job = 0 : 1,
         count = count + 1;
         [ Alphar, Alphai, Beta, Ao, Do, Bo, Fo, C1o, Vo, C2o, Q1, Q2 ] = ...
                            skewHamileig_nb( A, DE, C, VW, nb, job, cmpq11, cmpq21 );
         ev  = ( Alphar + Alphai*1i )./Beta;
         err = norm( ev - cmpoles( ev, evp ) )/max( 1, norm( evp ) );
         if err > tol,  disp( 'Failed 4' ),  return,  end
         max_err = max( max_err, err );
         Dot = triu( Do, 1 );
         Fot = triu( Fo, 1 );
         %
         So = [ Ao Dot-Dot'; zeros( m )  Ao' ];
         To = [ Bo Fot-Fot'; zeros( m )  Bo' ];
         Ho = [ C1o      Vo; zeros( m ) C2o' ];
         errm = max( [ norm( So - Q1'*S*J*Q1*J', 1 )/max( norm( So, 1 ), 1 ), ...
                       norm( To - J'*Q2'*J*S*Q2, 1 )/max( norm( To, 1 ), 1 ), ...
                       norm( Ho - Q1'*H*Q2,      1 )/max( norm( Ho, 1 ), 1 ) ] );
         if errm > tol,  disp( 'Failed 5' ),  return,  end
         max_err = max( max_err, errm );
      end
   end
end

if max_err < tol,
   disp( [ 'DGHUTP :    passed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
   disp( ' ' )
else
   disp( [ 'DGHUTP :    failed  -- maximum relative error max_err = ', num2str( max_err ) ] )
   disp( [ '            Number of problems solved                 = ', num2str( count   ) ] )
end
