function slicotmex( slicot_src )
%
% Function for compiling SLICOT subroutines using the built-in FORTRAN
% compiler of MATLAB. The archive file will be created inte parent
% directory.
%
% Arguments:
%
% slicot_src - path to the location of the slicot source files, the default
%              path will be used if not provided.
%
% Contributor:
% M. Voigt, Jul. 2014.
%
% Revisions:
% M. Voigt, Jun. 2015.
%
%% Set flags depending on machine architecture.
%
flags = '';
is64 = ( ~isempty( strfind ( computer, '64' ) ) );
if ( is64 )
    % 64-bit MATLAB
    flags = 'FFLAGS="$FFLAGS -fPIC -fno-omit-frame-pointer -fdefault-integer-8" -largeArrayDims';
end
%
%% Set location of the SLICOT source files.
%
if nargin == 0
    slicot_src = '../slicot/src/';
end
%
%% Compiling.
%
slicot = {
    'AB01MD', ...
    'AB01ND', ...
    'AB01OD', ...
    'AB04MD', ...
    'AB05MD', ...
    'AB05ND', ...
    'AB05OD', ...
    'AB05PD', ...
    'AB05QD', ...
    'AB05RD', ...
    'AB05SD', ...
    'AB07MD', ...
    'AB07ND', ...
    'AB08MD', ...
    'AB08ND', ...
    'AB08NX', ...
    'AB09AD', ...
    'AB09AX', ...
    'AB09BD', ...
    'AB09BX', ...
    'AB09CD', ...
    'AB09CX', ...
    'AB09DD', ...
    'AB09ED', ...
    'AB09FD', ...
    'AB09GD', ...
    'AB09HD', ...
    'AB09HX', ...
    'AB09HY', ...
    'AB09ID', ...
    'AB09IX', ...
    'AB09IY', ...
    'AB09JD', ...
    'AB09JV', ...
    'AB09JW', ...
    'AB09JX', ...
    'AB09KD', ...
    'AB09KX', ...
    'AB09MD', ...
    'AB09ND', ...
    'AB13AD', ...
    'AB13AX', ...
    'AB13BD', ...
    'AB13CD', ...
    'AB13DD', ...
    'AB13DX', ...
    'AB13ED', ...
    'AB13FD', ...
    'AB13ID', ...
    'AB13MD', ...
    'AG07BD', ...
    'AG08BD', ...
    'AG08BY', ...
    'BB01AD', ...
    'BB02AD', ...
    'BB03AD', ...
    'BB04AD', ...
    'BD01AD', ...
    'BD02AD', ...
    'DE01OD', ...
    'DE01PD', ...
    'DF01MD', ...
    'DG01MD', ...
    'DG01ND', ...
    'DG01NY', ...
    'DG01OD', ...
    'DK01MD', ...
    'FB01QD', ...
    'FB01RD', ...
    'FB01SD', ...
    'FB01TD', ...
    'FB01VD', ...
    'FD01AD', ...
    'IB01AD', ...
    'IB01BD', ...
    'IB01CD', ...
    'IB01MD', ...
    'IB01MY', ...
    'IB01ND', ...
    'IB01OD', ...
    'IB01OY', ...
    'IB01PD', ...
    'IB01PX', ...
    'IB01PY', ...
    'IB01QD', ...
    'IB01RD', ...
    'IB03AD', ...
    'IB03BD', ...
    'MA01AD', ...
    'MA02AD', ...
    'MA02BD', ...
    'MA02CD', ...
    'MA02DD', ...
    'MA02ED', ...
    'MA02FD', ...
    'MA02GD', ...
    'MA02HD', ...
    'MB01PD', ...
    'MB01QD', ...
    'MB01RD', ...
    'MB01RU', ...
    'MB01RW', ...
    'MB01RX', ...
    'MB01RY', ...
    'MB01SD', ...
    'MB01TD', ...
    'MB01UD', ...
    'MB01UW', ...
    'MB01VD', ...
    'MB01WD', ...
    'MB01XD', ...
    'MB01XY', ...
    'MB01YD', ...
    'MB01ZD', ...
    'MB02CD', ...
    'MB02CU', ...
    'MB02CV', ...
    'MB02CX', ...
    'MB02CY', ...
    'MB02DD', ...
    'MB02ED', ...
    'MB02FD', ...
    'MB02GD', ...
    'MB02HD', ...
    'MB02ID', ...
    'MB02JD', ...
    'MB02JX', ...
    'MB02KD', ...
    'MB02MD', ...
    'MB02ND', ...
    'MB02NY', ...
    'MB02OD', ...
    'MB02PD', ...
    'MB02QD', ...
    'MB02QY', ...
    'MB02RD', ...
    'MB02RZ', ...
    'MB02SD', ...
    'MB02SZ', ...
    'MB02TD', ...
    'MB02TZ', ...
    'MB02UD', ...
    'MB02UU', ...
    'MB02UV', ...
    'MB02VD', ...
    'MB02WD', ...
    'MB02XD', ...
    'MB02YD', ...
    'MB03MD', ...
    'MB03MY', ...
    'MB03ND', ...
    'MB03NY', ...
    'MB03OD', ...
    'MB03OY', ...
    'MB03PD', ...
    'MB03PY', ...
    'MB03QD', ...
    'MB03QX', ...
    'MB03QY', ...
    'MB03RD', ...
    'MB03RX', ...
    'MB03RY', ...
    'MB03SD', ...
    'MB03UD', ...
    'MB03VD', ...
    'MB03VY', ...
    'MB03WD', ...
    'MB03WX', ...
    'MB04DY', ...
    'MB04GD', ...
    'MB04ID', ...
    'MB04IY', ...
    'MB04JD', ...
    'MB04KD', ...
    'MB04LD', ...
    'MB04MD', ...
    'MB04ND', ...
    'MB04NY', ...
    'MB04OD', ...
    'MB04OW', ...
    'MB04OX', ...
    'MB04OY', ...
    'MB04PY', ...
    'MB04TT', ...
    'MB04TU', ...
    'MB04TV', ...
    'MB04TW', ...
    'MB04TX', ...
    'MB04TY', ...
    'MB04UD', ...
    'MB04VD', ...
    'MB04VX', ...
    'MB04XD', ...
    'MB04XY', ...
    'MB04YD', ...
    'MB04YW', ...
    'MB04ZD', ...
    'MB05MD', ...
    'MB05MY', ...
    'MB05ND', ...
    'MB05OD', ...
    'MB05OY', ...
    'MC01MD', ...
    'MC01ND', ...
    'MC01OD', ...
    'MC01PD', ...
    'MC01PY', ...
    'MC01QD', ...
    'MC01RD', ...
    'MC01SD', ...
    'MC01SW', ...
    'MC01SX', ...
    'MC01SY', ...
    'MC01TD', ...
    'MC01VD', ...
    'MC01WD', ... 
    'MC03MD', ... 
    'MC03ND', ... 
    'MC03NX', ... 
    'MC03NY', ...  
    'MD03AD', ... 
    'MD03BA', ... 
    'MD03BB', ... 
    'MD03BD', ... 
    'MD03BF', ... 
    'MD03BX', ...
    'MD03BY', ...  
    'NF01AD', ... 
    'NF01AY', ... 
    'NF01BA', ... 
    'NF01BB', ... 
    'NF01BD', ... 
    'NF01BE', ... 
    'NF01BF', ...
    'NF01BP', ... 
    'NF01BQ', ... 
    'NF01BR', ... 
    'NF01BS', ... 
    'NF01BU', ... 
    'NF01BV', ... 
    'NF01BW', ...
    'NF01BX', ... 
    'NF01BY', ...
    'SB01BD', ...
    'SB01BX', ... 
    'SB01BY', ... 
    'SB01DD', ...
    'SB01FY', ...
    'SB01MD', ... 
    'SB02CX', ...
    'SB02MD', ... 
    'SB02MR', ... 
    'SB02MS', ... 
    'SB02MT', ... 
    'SB02MU', ...
    'SB02MV', ...
    'SB02MW', ...
    'SB02ND', ... 
    'SB02OD', ...
    'SB02OU', ... 
    'SB02OV', ...
    'SB02OW', ...
    'SB02OX', ... 
    'SB02OY', ...
    'SB02PD', ... 
    'SB02QD', ... 
    'SB02RD', ...
    'SB02RU', ... 
    'SB02SD', ... 
    'SB03MD', ...
    'SB03MU', ...
    'SB03MV', ... 
    'SB03MW', ... 
    'SB03MX', ... 
    'SB03MY', ... 
    'SB03OD', ... 
    'SB03OR', ... 
    'SB03OT', ...
    'SB03OU', ... 
    'SB03OV', ... 
    'SB03OY', ... 
    'SB03PD', ...
    'SB03QD', ...
    'SB03QX', ... 
    'SB03QY', ...
    'SB03RD', ... 
    'SB03SD', ...
    'SB03SX', ...
    'SB03SY', ... 
    'SB03TD', ... 
    'SB03UD', ... 
    'SB04MD', ...
    'SB04MR', ... 
    'SB04MU', ...
    'SB04MW', ... 
    'SB04MY', ... 
    'SB04ND', ... 
    'SB04NV', ... 
    'SB04NW', ...
    'SB04NX', ... 
    'SB04NY', ... 
    'SB04OD', ...
    'SB04PD', ...
    'SB04PX', ... 
    'SB04PY', ... 
    'SB04QD', ...
    'SB04QR', ... 
    'SB04QU', ... 
    'SB04QY', ... 
    'SB04RD', ... 
    'SB04RV', ... 
    'SB04RW', ...
    'SB04RX', ...
    'SB04RY', ... 
    'SB06ND', ... 
    'SB08CD', ... 
    'SB08DD', ... 
    'SB08ED', ... 
    'SB08FD', ... 
    'SB08GD', ...
    'SB08HD', ... 
    'SB08MD', ... 
    'SB08MY', ... 
    'SB08ND', ... 
    'SB08NY', ... 
    'SB09MD', ... 
    'SB10AD', ...
    'SB10DD', ... 
    'SB10ED', ... 
    'SB10FD', ... 
    'SB10HD', ... 
    'SB10ID', ... 
    'SB10JD', ... 
    'SB10KD', ...
    'SB10MD', ... 
    'SB10LD', ... 
    'SB10PD', ... 
    'SB10QD', ... 
    'SB10RD', ... 
    'SB10SD', ... 
    'SB10TD', ...
    'SB10UD', ... 
    'SB10VD', ... 
    'SB10WD', ... 
    'SB10YD', ... 
    'SB10ZD', ... 
    'SB10ZP', ... 
    'SB16AD', ...
    'SB16AY', ... 
    'SB16BD', ... 
    'SB16CD', ... 
    'SB16CY', ... 
    'SG02AD', ... 
    'SG03AD', ... 
    'SG03AX', ...
    'SG03AY', ... 
    'SG03BD', ...
    'SG03BU', ... 
    'SG03BV', ...
    'SG03BW', ... 
    'SG03BX', ... 
    'SG03BY', ...
    'TB01ID', ... 
    'TB01KD', ...
    'TB01LD', ... 
    'TB01MD', ... 
    'TB01ND', ... 
    'TB01PD', ... 
    'TB01TD', ...
    'TB01TY', ... 
    'TB01UD', ... 
    'TB01VD', ... 
    'TB01VY', ... 
    'TB01WD', ... 
    'TB01XD', ... 
    'TB01YD', ...
    'TB01ZD', ... 
    'TB03AD', ... 
    'TB03AY', ... 
    'TB04AD', ... 
    'TB04AY', ... 
    'TB04BD', ... 
    'TB04BV', ...
    'TB04BW', ... 
    'TB04BX', ... 
    'TB04CD', ... 
    'TB05AD', ... 
    'TC01OD', ... 
    'TC04AD', ... 
    'TC05AD', ...
    'TD03AD', ... 
    'TD03AY', ... 
    'TD04AD', ... 
    'TD05AD', ... 
    'TF01MD', ... 
    'TF01MX', ... 
    'TF01MY', ...
    'TF01ND', ... 
    'TF01OD', ... 
    'TF01PD', ... 
    'TF01QD', ...
    'TF01RD', ... 
    'TG01AD', ... 
    'TG01BD', ...
    'TG01CD', ... 
    'TG01DD', ... 
    'TG01ED', ... 
    'TG01FD', ... 
    'TG01HD', ... 
    'TG01HX', ... 
    'TG01HY', ...
    'TG01ID', ... 
    'TG01JD', ... 
    'TG01JY', ... 
    'TG01WD', ...
    'UD01BD', ... 
    'UD01CD', ... 
    'UD01DD', ... 
    'UD01MD', ... 
    'UD01ND', ... 
    'select', ... 
    'delctg', ...
    'MA02ID', ... 
    'MA02JD', ... 
    'MB01MD', ... 
    'MB01ND', ... 
    'MB01UX', ...
    'MB03TD', ... 
    'MB03TS', ...
    'MB03WA', ... 
    'MB03XD', ... 
    'MB03XP', ... 
    'MB03XU', ... 
    'MB03YA', ... 
    'MB03YD', ...
    'MB03YT', ...
    'MB03ZA', ... 
    'MB03ZD', ... 
    'MB04DD', ... 
    'MB04DI', ... 
    'MB04DS', ... 
    'MB04PA', ... 
    'MB04PB', ...
    'MB04PU', ... 
    'MB04QB', ... 
    'MB04QC', ... 
    'MB04QF', ... 
    'MB04QU', ... 
    'MB04TB', ... 
    'MB04TS', ...
    'MB04WD', ... 
    'MB04WP', ... 
    'MB04WR', ... 
    'MB04WU', ...
    'SB04OW', ... 
    'UE01MD', ... 
    'UD01MZ', ...
    'AB08MZ', ... 
    'AB08NZ', ... 
    'AB8NXZ', ... 
    'AG08BZ', ... 
    'AG8BYZ', ...
    'MA02BZ', ...
    'MA02CZ', ...
    'MB04IZ', ... 
    'MB3OYZ', ... 
    'MB3PYZ', ...
    'TB01IZ', ...
    'TB01XZ', ... 
    'TG01AZ', ... 
    'TG01FZ', ...
    'MA01BD', ... 
    'MA01CD', ... 
    'MB01KD', ... 
    'MB01LD', ... 
    'MB02UW', ...
    'MB03AD', ... 
    'MB03BA', ...
    'MB03BB', ... 
    'MB03BC', ... 
    'MB03BD', ...
    'MB03BE', ... 
    'MB03CD', ... 
    'MB03DD', ... 
    'MB03ED', ...
    'MB03FD', ... 
    'MB03GD', ... 
    'MB03HD', ...
    'MB03ID', ... 
    'MB03JD', ...
    'MB03KA', ... 
    'MB03KB', ...
    'MB03KC', ... 
    'MB03KD', ...
    'MB03KE', ... 
    'MB03LD', ... 
    'MB04AD', ... 
    'MB04BD', ...
    'MB04HD', ...
    'MB04SU', ... 
    'MB04CD', ...
    'MB04ED', ... 
    'MB04FD', ... 
    'MA01BZ', ...
    'MA02GZ', ... 
    'MB03BZ', ...
    'MB03CZ', ...
    'MB03DZ', ... 
    'MB03FZ', ...
    'MB03GZ', ... 
    'MB03HZ', ... 
    'MB03IZ', ... 
    'MB03JZ', ...
    'MB03LF', ... 
    'MB03LZ', ...
    'MB03XS', ...
    'MB03XZ', ... 
    'MB04QS', ... 
    'MB04RB', ... 
    'MB04RU', ...
    'MB04BZ', ... 
    'MA02IZ', ... 
    'MB04DZ', ... 
    'MB04AZ', ...
    'MA02ES', ...
    'MA02EZ', ... 
    'MA02JZ', ...
    };
obj = [];
for k = 1:length(slicot)
    file = slicot{k};
    fprintf( 'mex -c %s %s%s.f\n', flags, slicot_src, file );
    eval( sprintf( 'mex -c %s %s%s.f\n', flags, slicot_src, file ) );
    obj = [ obj ' ' file '.o' ];
end
%
% Archive the object files.
%
unix( 'ar r ../mexslicot.a *.o' );
unix( 'rm *.o' );
