#!/usr/bin/perl -w

my @freq=(0,0,0,0,0,0,0,0,0,0);

my @partfreq;
my $time=0;

#
#   Get the outputs
#
system("ls output/* > out.tmp");
open(OUTPUTS, "<", "out.tmp");
my @lines = <OUTPUTS>;
close OUTPUTS;
unlink("out.tmp");

#
#  read the output files to get the frequency data
#
foreach my $filename (@lines)
{
 chomp($filename);
 open(DATA, "<", $filename);
 my @l = <DATA>;
 close(DATA);

 if ($l[0] =~ m/([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)/) {
   @partfreq=($1,$2,$3,$4,$5,$6,$7,$8,$9,$10);
 }
 for (my $i=0; $i<=9; $i++){
    $freq[$i]=  $freq[$i]+$partfreq[$i];
 }
}
########################################################################
#
#  Get the timing data from the nohup files
#  First get the nohups
#
system("ls nohup.out* > out.tmp");
open(NOHUPS, "<", "out.tmp");
@lines = <NOHUPS>;
close NOHUPS;
unlink("out.tmp");
#
#   Get the timing data
#
foreach my $filename (@lines)
{
    chomp($filename);
    open(NH, "<", $filename);
    my @l = <NH>;
    close(NH);
 foreach my $li (@l)
 {
  if ($li =~ m/^[1-9]/)
  {
      $time = $time + $li;
  }
 }
}

#############################3###########################################
#
#  Print a summary of the calculation
#
print "Frequency table of number real solutions\n \# Real   ";
for (my $i=0; $i<=9; $i++){
  printf  "%5d ", 2*$i;
}
 printf "\n Frequency";

my $total=0;
for (my $i=0; $i<=9; $i++){
  printf  "%5d ", $freq[$i];
  $total = $total + $freq[$i];
}
printf "\n";
printf "There have been %d instances computed in %4.2f days on Schubert.\n", $total, $time/3600/24;
printf "Each instance takes %4.1f seconds.\n", $time/$total;
printf "This computation used %d seconds.\n", $time;
#printf "This computation used %5.1f hours.\n", $time/3600;
#printf "This computation used %5.2f days.\n", $time/3600/24;


