#!/usr/bin/perl -w
##############################################################
# Perl code to compute space conics containing the origin and
# meeting six lines
#
# Began: 20 September 2010
#
# Frank Sottile and Jonathan Hauenstein
#
#  The file first sets up a random number generator with a seed that should be 
# unique to this session.
#
#
#
#
################################################################
use 5.008006;
use strict;
use warnings;
my @numarr;
my @lines;
my $status;
my $line;
my @oldfreq;

my $size = 1000;
#
#  Set the random number generator to something squirrely 
#  involving the epoch and process ID
#
# Documentation: http://search.cpan.org/~fangly/Math-Random-MT-Perl-1.06/lib/Math/Random/MT/Perl.pm
# 
use LIBS::MathRandomMTPerl;
#
my $date=time;
my $number = int(($date-1285295700)*($date-1280000400)/$$)+$$;
print "Seed for PID ", $$, " is ", $number, "  size of numbers is ",$size,"\n";
&Math::Random::MT::Perl::srand($number); 

sub drand {
  return int(&Math::Random::MT::Perl::rand($size))+1;
}
sub nrand {
#  return int(&Math::Random::MT::Perl::rand(200000000)-100000000);
  return int(&Math::Random::MT::Perl::rand(4*$size)-2*$size);
}

##########################################################################
#
#  Make sure temp directory exists
#
use Sys::Hostname; my $hn = hostname;	   # get computer host name
  if ( ! (-e "tempfiles/$hn"
              && -d "tempfiles/$hn") ) {
    mkdir("tempfiles/$hn")
      or die "Couldn't create temp directory (tempfiles/$hn).";
  }
############################################################################
#
#  Set up filenames  
#  The filenames will include the process number
#
my $fileroot = "tempfiles/$hn/conics.$$";
my $singularfile = "$fileroot.sing";
my $maplefile = "$fileroot.maple";
my $datafile = "$fileroot.data";
my $outputfile = sprintf "output/%d.out", $date-1285295700;

open(OUTPUTFILE, ">", "$outputfile");
printf  OUTPUTFILE "0 0 0 0 0 0 0 0 0 0 \n";
close(OUTPUTFILE);
open(OUTPUTFILE, "<$outputfile");
@lines = <OUTPUTFILE>;
close OUTPUTFILE;
# 

#  An early test took 3.6 hours to compute 20 instances. This means about 1000 in 1 week,
# but we'll do it in 10 instance chunks
#
for (my $j=1; $j<=100; $j++){
  my @freq=(0,0,0,0,0,0,0,0,0,0,0);
  ###########################################################################
  #
  #  Singular header
  #
  #  Note: we assume that the data will always be generic, there is only as small test for
  #   nongenericity.
  #
  open(SING, ">$singularfile");

  printf SING  "LIB \"LIBS/conics.lib\";\n" or return -1;
  printf SING  "int T=timer;\n";
  #printf SING  "ring R = 32003, (a,b,c,d,u,v), dp;\n";
  printf SING  "ring R = 0, (a,b,c,d,u,v), dp;\n";
  printf SING  "ideal I;\n";
  printf SING  "poly e;\n";
  printf SING  "link l=\":w %s\";\n", $maplefile;
  printf SING  "fprintf(l, \"interface(quiet=true):\");\n"; 
  printf SING  "fprintf(l, \"file:=fopen(\\\"%s\\\",WRITE):\");\n", $datafile; 

  ########################################################################################
  for (my $i=1; $i<=10; $i++){
    printf SING "I = \n";
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr  = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u);\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "e = eliminate(I,bcduv)[1];\n";
    printf SING "if (deg(e)<>18) {\n";
    printf SING " I = \n";
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u),\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING "  Eqn(%d/%u,%d/%u,%d/%u,%d/%u,%d/%u,%d/%u);\n", @numarr;
      @numarr = (nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand(), nrand(),drand());
    printf SING " e = eliminate(I,bcduv)[1];\n";
    printf SING "}\n";
    printf SING "if (deg(e)==18) {\n";
    printf SING " short=0;\n";
    printf SING " fprintf(l, \"F:=%%s:\\\\n\", e);\n"; 
    printf SING " fprintf(l, \"fprintf(file, \\\"%%d\\\\n\\\",nops(realroot(F))):\");\n"; 
    printf SING "}\n";
  }
  ########################################################################################
  printf SING  "fprintf(l, \"fclose(file):\");\n"; 
  printf SING  "fprintf(l, \"quit:\");\n"; 
  print  SING  "timer-T;\n" or return -1;
  print  SING  "quit;\n" or return -1;
  close(SING);
  ########################################################################################
  # 
  #  Now run the Singular and the maple file
  #
  $status = system("nice -n20 Singular -q < $singularfile");
  if ( $status != 0 ) {
    # Singular run failed.
    # Put an error message and stop the computation.
    die "Singular run failed.";
  }
  $status = system("nice -n20 maple -q < $maplefile");
  if ( $status != 0 ) {
    # Maple run failed.
    # Put an error message and stop the computation.
    die "Maple run failed.";
  }
  ########################################################################################
  # 
  #  Read the data
  #
  open(DATAFILE, "<$datafile");
  @lines = <DATAFILE>;
  close DATAFILE;
  foreach my $l (@lines) {
    chomp($l);
    $freq[$l/2]++;
  }
  #
  #  Now we need to write the data and status to a file for safekeeping and monitoring
  #
  #
  open(OUTPUTFILE, "<$outputfile");
  @lines = <OUTPUTFILE>;
  close(OUTPUTFILE);
  if ($lines[0] =~ m/([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)\s*([0-9]+)/) {
    @oldfreq=($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,);
  }

   print $lines[0];  

  open(OUTPUTFILE, ">$outputfile");
  for (my $i=0; $i<=9; $i++){
    printf OUTPUTFILE "%d ", $oldfreq[$i]+$freq[$i];
  }
  printf OUTPUTFILE "\n";
  close(OUTPUTFILE);
  
  unlink($singularfile);
  unlink($maplefile);
  unlink($datafile);
}
