function [fs,ls] = pqtreenodes(root,f,fs,ls,node)
%PQTREENODES converts a PQ tree to "treeplot" format.
%   [fs,ls] = pqtreenodes(T,...) converts the PQ tree whose root is T to the
%   format used by the function treeplot of Matlab.
%   This function is back used in pqtreeplot. It is not intended to be
%   called by a user.
%
%   See also pqtreegetnode, pqtreeplot.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

%   root is the root of the tree
%   fs is the vector of pointers to parent nodes 
%   ls is the vector of the type labels for the nodes 

if (nargin<5) || isempty(node), node = 0; end
if nargin<3, fs = []; ls = []; end
if (nargin<2) || isempty(f), f = 0; end

fs = [fs,f];
if node && (length(fs) == node)
	fs = root;
	ls = [];
	return
end

switch root.type
	case 'L'
		ls = [ls,root.value]; % for a leaf, the label is its value
	case {'M','P','Q'}
		vec = root.value;
		newf = length(fs);
		if root.type == 'P'
			ls = [ls,-1];
		elseif root.type == 'Q' 
			ls = [ls,-2];
		elseif root.type == 'M'
			ls = [ls,-3];
		end
		for i = 1:length(vec)
			[fs,ls] = pqtreenodes(vec(i),newf,fs,ls,node);
			if isempty(ls), return, end
		end
	otherwise
		error('unknown type');
	end
end

