function pqtreegetnode(~,point,fs,ls,x,y,T,opts)
%PQTREEGETNODE extract a subtree from a PQ tree.
%   pqtreegetnode(...,T) extracts a subtree from the PQ tree with root T,
%   plots the subtree in a new figure, and saves it to a variable in the
%   workspace.
%   This function is a call-back used in pqtreeplot. It is not intended to
%   be called by a user.
%
%   See also pqtreeplot.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

maxlines = 20;

xx = point.IntersectionPoint(1);
yy = point.IntersectionPoint(2);
[~,ind] = min((x-xx).^2+(y-yy).^2);
v = (fs==ind);
w = ls(v);

switch ls(ind)
	case -3
		str1 = sprintf('M-node with %d children',length(w));
	case -2
		str1 = sprintf('Q-node with %d children',length(w));
	case -1
		str1 = sprintf('P-node with %d children',length(w));
	otherwise
		str1 = sprintf('leaf(%d)',ls(ind));
end
fprintf('\nNode: %s\n',str1);

if fs(ind)==0
	fprintf('Father: none\n');
else
	switch ls(fs(ind))
		case -3
			str2 = 'M-node';
		case -2
			str2 = 'Q-node';
		case -1
			str2 = 'P-node';
		otherwise
			error('error in data set')
	end
	fprintf('Father: %s\n',str2);
end

fprintf('Children: ')
if isempty(w), fprintf('none\n'), end
for i = 1:min(maxlines,length(w))
	switch w(i)
		case -3
			str3 = 'M-node';
		case -2
			str3 = 'Q-node';
		case -1
			str3 = 'P-node';
		otherwise
			str3 = sprintf('leaf(%d)',w(i));
	end
	fprintf('%s\n          ',str3);
end
if maxlines<length(w), fprintf('...\n'), else fprintf('\n'), end

% construction of the subtree
subtree = pqtreenodes(T,[],[],[],ind);
assignin('base','PQsubtree',subtree);
fprintf('The subtree is in the workspace variable "PQsubtree".\n')

if subtree.type ~= 'L'
	figure
	opts.labelson = 1;
	pqtreeplot(subtree,opts);
end

