function n = pqtreeNperm(root)
%PQTREENPERM number of admissible permutations in a PQ tree.
%   n = pqtreeNperm(T) returns the number of all the permutations contained
%   in the PQ tree whose root is T.
%
%   See also pqtree1perm, pqtreeperms, pqtreeplot.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

switch root.type
	case 'L'
		n = 1;
	case {'P','Q','M'}
		c = root.value;
		v = zeros(1,length(c));
		for i = 1:length(c)
			v(i) = pqtreeNperm(c(i));
		end
		if root.type == 'Q'
			n = 2*prod(v);
		else 
			n = prod(1:length(c))*prod(v);
		end
	otherwise
		error('unknown type');
end

