function perm = pqtree1perm(T)
%PQTREE1PERM extract an admissible permutation from a PQ tree.
%   perm = pqtree1perm(T) extracts one of the admissible permutations
%   contained in the PQ tree whose root is T.
%
%   See also pqtreeNperm, pqtreeperms, pqtreeplot.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

switch T.type
	
	case 'L'
		perm = T.value;
		return
		
	case {'P','Q','M'}
		w = T.value;
		nw = length(w);
		P = pqtree1perm(w(1));
		for i = 2:nw
			Q = pqtree1perm(w(i));
			P = [P Q];
		end
		perm = P;

end

