function node = pnode(vec)
%PNODE	add a P node to a PQ tree.
%   node = pnode(vec) creates a P node. If vec is numeric, it contains the
%   values of the leaf nodes, otherwise it must be a subtree.
%
%   See also qnode, lnode, pqtreeplot.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

if isnumeric(vec)
	if size(vec,1)>1, error('vec must be a row vector'), end
	n = size(vec,2);
	if n<2, error('vec must contain at least 2 elements.'), end
	vec = struct('type',mat2cell(repmat('L',n,1),ones(n,1)), ...
		'value',mat2cell(vec',ones(n,1)));
end
node = struct('type','P','value',vec);

