function L = lapl(A)
%LAPL	construct the graph Laplacian of a matrix.
%   L=lapl(A) returns the graph Laplacian of the adjacency matrix A.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

n = size(A,1);
D = A*ones(n,1);
L = spdiags(D,0,n,n)-A;
