function list = graphvisit(root,list)
%GRAPHVISIT visit a graph starting from a node.
%   list = graphvisit(node) visits a graph defined by an adjacency matrix,
%   starting from node "node". Returns a list of the visited nodes.
%   This function is called by getconcomp.
%   Warning: to reduce stack usage, a global matrix AGLOB is used.
%
%   See also getconcomp.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

global AGLOB;

l = find(AGLOB(root,:)); % list of the indices of the nodes connected to root
newlist = []; % nodes absent in list

for i = 1:length(l)
	if ~any(l(i)==list)
		list = [list l(i)]; % add every element of l not in the list
		newlist = [newlist l(i)]; % save node in newlist
	end
end

if length(newlist) > 0
	list = sort(list);
	for i = 1:length(newlist)
		list = graphvisit(newlist(i),list);
	end
end

