function  U = getconcomp(A,opts)
%GETCONCOMP determine the connected components of a graph.
%   U = getconcomp(A) returns a cell array containing the vector of indices
%   which identify the connected components of the graph corresponding to
%   the adjacency matrix A.
%   U = getconcomp(A,opts) optionally passes a set of options.
%   Warning: to reduce stack usage, a global matrix AGLOB is used.
%
%   options:
%   opts.maxncomp bound for the number of connected components (def. 100).
%
%   See also spectrsort, pspectrsort.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

global AGLOB; % declare as global the input matrix
AGLOB = A;
AGLOB = abs(AGLOB) | abs(AGLOB');

if nargin < 2 || isempty(opts), opts = struct('empty','empty'); end

nam = fieldnames(opts);
% max number of connected components
if ~any(strcmpi('maxncomp',nam)), opts.maxncomp = 100; end

n = size(A,1);
root = 1;
list = root;
flag = 1;
i = 0;
chlist = [];
U = cell(1,opts.maxncomp); % preallocation

while flag
	i = i+1;
	list = graphvisit(root,list);
	U{i} = list;
	chlist = sort([chlist list]);
	flag = (length(chlist)~= n);
	if flag
		% root computation in the case of a new connected component
		root = find(diff(chlist)-1,1) + 1;
		if isempty(root) % root restore for a 'complete' sorted chlist
			root = chlist(end) + 1;	% (to avoid loops)
		end
		list = [root];
	end
	if ~rem(i,100)
		U{i+opts.maxncomp} = {};
	end
end
U = U(1:i); % remove the empty components

