function [w,iw,iiw] = distinct(v,tau)
%DISTINCT sort and level the elements of a vector.
%   w = distinct(v) sorts the vector v and make equal all the elements that
%   differ more than tau.
%   [w,iw,iiw] = distinct(v) returns two vectors of indices such that
%   w=v(iw) and v=w(iiw).
%
%   See also spectrsort, pspectrsort, fiedvecs.

%   A. Concas, C. Fenu & G. Rodriguez, University of Cagliari, Italy
%   Email: concas.anna@gmail.com, kate.fenu@gmail.com, rodriguez@unica.it
%
%   Last revised Aug 20, 2017

if nargin<2, tau = 1e-8; end

[w,iw] = sort(v(:),'ascend');
dw = diff(w);
if tau > 0
	k1 = (dw < tau) & (dw > 0);
	while any(k1)
		k2 = find(diff([0;k1])>0);
		w(k2+1) = w(k2);
		dw = diff(w);
		k1 = (dw < tau) & (dw > 0);
	end
end
if nargout>2, [~,iiw] = sort(iw); end

