%TUTORIAL PQser tutorial

close all
clear all
m = 10;		% units number
n = 10;		% types number
opts.bw = 2;
opts.tau = 1e-8;
n_c = [5 6 4];

clc

fprintf('*******************************\nCREATING A LEAF\n\nl=lnode(1)')
l = lnode(1) 
fprintf('pause (press a key to continue)\n\n')
pause

fprintf('*******************************\nCREATING A P-NODE\n\nP=pnode([2:4])')
P = pnode(2:4)
fprintf('pause (press a key to continue)\n\n')
pause

fprintf('*******************************\nCREATING A Q-NODE\n\nQ=qnode([5:7])')
Q = qnode(5:7)
fprintf('pause (press a key to continue)\n\n')
pause

fprintf('*******************************\nCREATING A M-NODE\n\nM=mnode([8:15])')
M = mnode([8:15])
fprintf('pause (press a key to continue)\n\n')
pause

fprintf('******************************************************************\n')
fprintf('CREATING A PQ-TREE WITH A P-NODE AS ROOT AND CHILDREN P,Q,M,l\n\n')

echo on
v(1) = P;
v(2) = Q;
v(3) = M;
v(4) = l;

T = pnode(v)
echo off % press a key to continue
fprintf('\n')
pause

fprintf('**********************************************\n')
fprintf('REPRESENTATION OF THE PREVIOUS PQ-TREE\n\npqtreeplot(T)\n\n')
h1 = figure();
set(gcf,'NumberTitle','off');
set(gcf,'Name','PQ-tree with a P node as a root');
pqtreeplot(T) % representation of the PQ-tree T
  
fprintf('click on one node to extract a subtree\n')
pause
close all

fprintf('\n')
fprintf('**********************************************\n')
fprintf('REORDERING A PRE-R IRREDUCIBLE MATRIX\n\n')

fprintf('Step 1: CREATING AN ABUNDANCE MATRIX (R MATRIX)\n\n') 


Ai = tril(triu(ones(m,n),-2),2);	% incidence matrix
di = Ai*ones(n,1);
Ab = diag(100./di)*Ai;	% abundance matrix, one representative for each type
n = size(Ab,1);
tau = 100*eps;
R = zeros(n);
e = ones(n,1);
for i = 1:n-1
	M = diag([zeros(i,1);ones(n-i,1)]);
	M(i+1:n,i) = -1;
	v = 200 - abs(M*Ab)*e;
	v(v<tau) = 0;
	R(i:n,i) = v(i:n);
	R(i,i+1:n) = v(i+1:n)';
end
R(n,n) = 200;

scrsz = get(0,'ScreenSize');
hR = figure('Position',[100 scrsz(4) scrsz(3)*3/4 scrsz(3)/4]);
axis off;
set(hR,'NumberTitle','off','Name','REORDERING A PRE-R IRREDUCIBLE MATRIX')


ax(1)=axes('position',[0.12 0.07 0.25 0.85]);
axis square
imagesc(R) % R-matrix, similarity matrix (using the Robinson criterion)
set(gca,'xtick',[],'ytick',[]);
title('R-matrix')

colormap(jet);
h = colorbar;
set(h,'position',[0.05 0.07 0.05 0.85])

disp(R)

fprintf('the matrix is represented graphically in the figure\n\n')
fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 2: CREATING A PRE-R MATRIX (BY RANDOMLY PERMUTING THE PREVIOUS MATRIX)\n\n')

u = randperm(m);
A = R(u,u);

figure(hR);
ax(2) = axes('position',[0.42 0.07 0.25 0.85]);
axis square
imagesc(A)
set(gca,'xtick',[],'ytick',[]);
title('Permuted matrix')

disp(A)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 3: PQ-TREE CONSTRUCTION AND REPRESENTATION\n\nT = spectrsort(A,opts)\n')

T = spectrsort(A,opts)

hT = figure;
set(hT,'NumberTitle','off','Name','PQ-tree related to an R matrix');
fprintf('pqtreeplot(T)\n\n')
pqtreeplot(T)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('NUMBER OF ADMISSIBLE PERMUTATIONS: \n\npqtreeNperm(T)\n\n')
nn = pqtreeNperm(T);
disp(nn)
fprintf('\n')

fprintf('EXTRACTING ALL THE ADMISSIBLE PERMUTATIONS FROM T\n\npqtreeperms(T)\n\n')
perms_matrix = pqtreeperms(T);
disp(perms_matrix)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('EXTRACTING AN ORDERING SEQUENCE FROM T\n\nseq=pqtree1perm(T)\n\n')
seq = pqtree1perm(T);
disp(seq)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 4: REORDERING THE MATRIX\n\n')
AR = A(seq,seq);
fprintf('AR = A(seq,seq)\n\n')

figure(hR);
ax(3)=axes('position',[0.72 0.07 0.25 0.85]);
axis square
imagesc(AR)
set(gca,'xtick',[],'ytick',[]);
title('Reordered matrix')

disp(AR)

fprintf('pause (press a key to continue)\n\n')
pause

close(hT)
close(hR)

fprintf('**********************************************\n')
fprintf('AN EXAMPLE WITH THREE CONNECTED COMPONENTS\n\n')

fprintf('Step 1: CREATING A REDUCIBLE MATRIX WITH 3 IRREDUCIBLE BLOCKS\n\n')

k = length(n_c);
A = [];
for i = 1:k
	A1 = tril(triu(ones(n_c(i),n_c(i)),-opts.bw),opts.bw);
	A = blkdiag(A,A1);
end

hB = figure('Position',[100 scrsz(4) scrsz(3)*3/4 scrsz(3)/4]);
axis off;
set(hB,'NumberTitle','off','Name','REDUCIBLE MATRIX WITH 3 IRREDUCIBLE BLOCKS')

ax(1)=axes('position',[0.12 0.07 0.25 0.85]);
axis square
spy(A)
set(gca,'xtick',[],'ytick',[]);
title('Starting matrix')

disp(A)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 2: PERMUTING THE MATRIX\n\n')

m = size(A,1);
u = randperm(m);
A = A(u,u);

figure(hB);
ax(2)=axes('position',[0.42 0.07 0.25 0.85]);
axis square
spy(A)
set(gca,'xtick',[],'ytick',[]);
title('Permuted matrix')

disp(A)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 3: PQ-TREE CONSTRUCTION AND REPRESENTATION\n\nT = spectrsort(A,opts)\n')
T = spectrsort(A,opts)

fprintf('pqtreeplot(T)\n\n')
hT2 = figure;
set(hT2,'NumberTitle','off');
set(hT2,'Name','PQ-tree related to a matrix with 3 components');
pqtreeplot(T)

fprintf('NUMBER OF ADMISSIBLE PERMUTATIONS: \n\npqtreeNperm(T)\n\n')
nn = pqtreeNperm(T);
disp(nn)
fprintf('\n')

fprintf('EXTRACTING ALL THE ADMISSIBLE PERMUTATIONS FROM T\n\npqtreeperms(T)\n\n')
perms_matrix = pqtreeperms(T);
fprintf('press a key to see them\n\n')
pause
disp(perms_matrix)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('EXTRACTING AN ORDERING SEQUENCE FROM T\n\nseq=pqtree1perm(T)\n\n')
seq = pqtree1perm(T);
disp(seq)

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 4: REORDERING THE MATRIX\n\n')
AR = A(seq,seq);
fprintf('AR = A(seq,seq)\n\n')

figure(hB);
ax(3)=axes('position',[0.72 0.07 0.25 0.85]);
axis square
spy(AR)
set(gca,'xtick',[],'ytick',[]);
title('Reordered matrix')

disp(AR)

fprintf('pause (press a key to continue)\n\n')
pause

close(hT2)
close(hB)

fprintf('**********************************************\n')
fprintf('A LARGER EXAMPLE\n\n')

fprintf('Step 1: CREATING A SPARSE MATRIX OF DIMENSION 1000 WITH 10 CONNECTED COMPONENTS\n\n')

m = 10;		% units number
n = 10;		% types number
n_c = zeros(10,1);
opts.bw = 10;
for i = 1:length(n_c)
	n_c(i) = 100;
end
k = length(n_c);
A = [];
for i = 1:k
	A1 = spdiags(ones(n_c(i),2*opts.bw+1), ...
		[-opts.bw:opts.bw],n_c(i),n_c(i));
	A = blkdiag(A,A1);
end

hB2 = figure('Position',[100 scrsz(4) scrsz(3)*3/4 scrsz(3)/4]);
axis off;
set(hB2,'NumberTitle','off','Name','SPARSE MATRIX WITH 10 CONNECTED COMPONENTS')

ax(1)=axes('position',[0.12 0.07 0.25 0.85]);
axis square
spy(A)
set(gca,'xtick',[],'ytick',[]);
title('Starting matrix')

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 2: PERMUTING THE MATRIX\n\n')

m = size(A,1);
u = randperm(m);
A = A(u,u);

figure(hB2);
ax(2)=axes('position',[0.42 0.07 0.25 0.85]);
axis square
spy(A)
set(gca,'xtick',[],'ytick',[]);
title('Permuted matrix')

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 3: PQ-TREE CONSTRUCTION AND REPRESENTATION\n\nT = spectrsort(A,opts)\n')

T = spectrsort(A,opts)

hT3 = figure;
set(hT3,'NumberTitle','off');
set(hT3,'Name','PQ-tree related to a matrix with 10 components');
fprintf('pqtreeplot(T)\n\n')
pqtreeplot(T)

fprintf('click on one node to extract a subtree\n')
pause

fprintf('NUMBER OF ADMISSIBLE PERMUTATIONS: \n\npqtreeNperm(T)\n\n')
nn = pqtreeNperm(T);
disp(nn)
fprintf('\n')

fprintf('EXTRACTING AN ORDERING SEQUENCE FROM T\n\nseq=pqtree1perm(T)\n\n')
seq = pqtree1perm(T);
fprintf('(too long to be displayed)\n\n')

fprintf('pause (press a key to continue)\n\n')
pause

fprintf('Step 4: REORDERING THE MATRIX\n\n')
AR = A(seq,seq);
fprintf('AR = A(seq,seq)\n\n')

figure(hB2);
ax(3)=axes('position',[0.72 0.07 0.25 0.85]);
axis square
spy(AR)
set(gca,'xtick',[],'ytick',[]);
title('Reordered matrix')

figure(hB2);
ax(3)=axes('position',[0.72 0.07 0.25 0.85]);
axis square
spy(AR)
set(gca,'xtick',[],'ytick',[]);
title('Reordered matrix')

fprintf('End of tutorial.\n\n')

