%MFIEDVAL reproduce the experiment in Section 5 of the paper.

n = 5;
m = 10000;

A = eye(n) + diag(ones(n-1,1),1) + diag(1,1-n)
F = A*A'
L = lapl(F)
disp('press a key...'), pause

omega = exp(2*pi*1i/n)
Lhat = @(z) 2-z.^(-1)-z.^(-(n-1))
lambdas = Lhat(omega.^[0:n-1]);
if norm(imag(lambdas))>1e-8, error('Something went wrong.'), end
lambdas = real(lambdas)
disp('press a key...'), pause

%v = omega.^[0:n-1]';
%V = 1/sqrt(5)*[ones(n,1) v v.^2 v.^3 v.^4];
[V D] = eig(L);
fiedval = lambdas(2)
fiedvec1 = V(:,2)
fiedvec2 = V(:,3)
disp('press a key...'), pause

perms = zeros(n,m);
redperms = zeros(n,1);
k = 0;
j = 0;
for i = 1:m
	w = randn(2,1);
	vec = [fiedvec1 fiedvec2]*w;
	[ww kk] = sort(vec);
	perms(:,i) = kk;
	if ~any(all(redperms==kk))
		k = k+1;
		redperms(:,k) = kk;
		if ~any(all(redperms==flipud(kk)))
			j = j+1;
		end
	end
end
disp(' ')
disp('different permutations found:')
disp(redperms)
fprintf('possible permutations  : %d\n',factorial(n))
fprintf('admissible permutations: %d\n',k)
fprintf('ignoring swapped perms.: %d\n',j)

