%GRAF2	reproduce the experiment in Figure 2 of the paper.

m = 10;
n = 10;
Ai = tril(triu(ones(m,n),-2),2);	
di = Ai*ones(n,1);
Ab = diag(100./di)*Ai;	% abundance matrix, considering one object for each type
n = size(Ab,1);
tau = 100*eps;
R = zeros(n);
e = ones(n,1);
for i = 1:n-1
	M = diag([zeros(i,1);ones(n-i,1)]);
	M(i+1:n,i) = -1;
	v = 200 - abs(M*Ab)*e;
	v(v<tau) = 0;
	R(i:n,i) = v(i:n);
	R(i,i+1:n) = v(i+1:n)';
end
R(n,n) = 200;		% similarity matrix in R-form
u = randperm(m);
A = R(u,u);		% pre-R matrix

T = spectrsort(A);	% PQ-tree construction

opts.fontsize = 14;
opts.markersize = 12;
pqtreeplot(T,opts);	% PQ-tree representation

perms_matrix = pqtreeperms(T);	% compute the permutations matrix

seq = pqtree1perm(T);	% extract an ordering sequence from T

AR = A(seq,seq);	% reordered matrix

