%EXPER2	reproduce the experiment in Figure 5 of the paper.

if exist('parpool') ~= 2
	error('This script requires the Parallel Computing Toolbox for Matlab.')
end

%numworkers = 12;	% number of processing units
numworkers = [1 1000];	% this is likely to select the maximum allowed number

m = 10; 		% max power of 2
%m = 15; 		% value used in the paper, it takes time

show = 2;	% 1-2 to display graphs, 0 to compute and save the results
opts.bw = 16;	% half-bandwidth of test matrix
fsiz = 8;	% font size

if ~isempty(gcp('nocreate'))
	delete(gcp)
end
mypool = parpool(numworkers);
numworkers = mypool.NumWorkers;

vm = [1:m]';		% powers of 2
n = pow2(m);		% size of the matrix
vn1 = pow2(vm);		% size of blocks in each test
vn2 = n./vn1;		% number of blocks in each test

tim1 = zeros(m,1);
tim2 = zeros(m,1);

for i = 1:m
	i
	n1 = vn1(i);
	n2 = vn2(i);
	n_c = n1*ones(1,n2);
	[A R] = testmatr(2,n_c,opts);
	tic
	T1 = spectrsort(A);
	tim1(i) = toc;
	tic
	T2 = pspectrsort(A);
	tim2(i) = toc;
	if show > 1
		figure(1)
		spy(A)
		title('Permuted matrix')
		figure(2)
		spy(R)
		title('Reordered matrix')
		timings = [tim1(i) tim2(i)]
		disp('press any key...')
		pause
	end
end

if show
	figure(3)
	hh = plot(vm,tim1,'o-',vm,tim2,'o--');
	set(gca,'fontsize',fsiz)
	set(hh(1),'linewidth',2)
	set(hh(2),'linewidth',2)
	legend('sequential','parallel')
else
	filnam = sprintf('exper2_%d',numworkers);
	save(filnam,'numworkers','m','n','vm','vn1','vn2','tim1','tim2')
end

