% PQser: seriation problem solver via PQ trees.
%
% Main functions
%   spectrsort    - spectral sort for the seriation problem
%   pspectrsort   - spectral sort for the seriation problem, parallel version.
%   testmatr      - test matrices for PQser.
%   fiedvecs      - compute the Fiedler vectors and values of a Laplacian.
%   getconcomp    - determine the connected components of a graph.
%
% PQ trees operations
%   pqtree1perm   - extract an admissible permutation from a PQ tree.
%   pqtreegetnode - extract a subtree from a PQ tree.
%   pqtreenodes   - converts a PQ tree to "treeplot" format.
%   pqtreeNperm   - number of admissible permutations in a PQ tree.
%   pqtreeperms   - extract all admissible permutations from a PQ tree.
%   pqtreeplot    - plot a PQ tree.
%   pnode         - add a P node to a PQ tree.
%   qnode         - add a Q node to a PQ tree.
%   mnode         - add a M node to a PQ tree.
%   lnode         - add a leaf node to a PQ tree.
%
% Utilities
%   distinct      - sort and level the elements of a vector.
%   graphvisit    - visit a graph starting from root.
%   lapl          - construct the graph Laplacian of a matrix.
