function M = femX_stima4(vertices)
% function M = femX_stima4(X)
%
%   Spatial element stiffness matrix for a parallelogram
%
%   X has dimension 4 x 2 containing the x- & y-coordinates
%   The vertices are numbered anti-clockwise

%   R. Andreev, 2012.10.25
%
%   The femX_* code is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137

	D_Phi = [vertices(2,:)-vertices(1,:); vertices(4,:)-vertices(1,:)]';
	B = inv(D_Phi'*D_Phi);
	C1 = [2,-2;-2,2]*B(1,1)+[3,0;0,-3]*B(1,2)+[2,1;1,2]*B(2,2);
	C2 = [-1,1;1,-1]*B(1,1)+[-3,0;0,3]*B(1,2)+[-1,-2;-2,-1]*B(2,2);
	M = det(D_Phi) * [C1 C2; C2 C1] / 6;
end
